#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More;
use Test::Exception;

use Yandex::TimeCommon;

dies_ok {mysql2unix(undef)};
dies_ok {mysql2unix('')};
dies_ok {mysql2unix('asdfewrq')};
dies_ok {mysql2unix('0000-00-00 00:00:00')};

# странное поведение, стоит изменить?
is(mysql2unix('0'), '0');

is(mysql2unix('1970-01-01 03:00:00'), 0);
is(mysql2unix('1970-01-01 04:01:01'), 3661);

for my $t ('20121212120212', '20000112232156', '19801024081234') {
    is(unix2mysql(mysql2unix($t)), $t);
}

done_testing();
