#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use Test::More;
use Test::Exception;

use Yandex::TimeCommon;

my @tests = (
    # [$agg => $input, $expected_output]
    [day     => '2015-01-13 13:13:13', '2015-01-13'],
    [week    => '2015-01-13 13:13:13', '2015-01-12'],
    [month   => '2015-01-31 13:13:13', '2015-01-01'],
    [quarter => '2015-07-06 13:13:13', '2015-07-01'],
    [year    => '2015-01-13 13:13:13', '2015-01-01'],
);

for my $test (@tests) {
    my ($agg, $input, $expected_output) = @$test;

    is(str_round($input, $agg), $expected_output, "str_round('$input', '$agg') == '$expected_output'");
}

dies_ok { str_round('2015-01-13 13:13:13', 'bad aggregator') } 'unknown aggregation type';

done_testing;
