#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use Test::More;

use Yandex::TimeCommon;

my @tests = (
    # [$input, $expected_output]
    ['0000-00-00 00:00:00', '0000-00-00'],
    ['2015-01-13 13:13:13', '2015-01-13'],
    ['2015-01-01 13:13:13', '2015-01-01'],
    ['20150101131313', '2015-01-01'],
);

Test::More::plan(tests => scalar(@tests));

for my $test (@tests) {
    my ($input, $expected_output) = @$test;

    is(str_round_day($input), $expected_output, "str_round_day('$input') == '$expected_output'");
}
