#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use Test::More;
use Test::Exception;

use Yandex::TimeCommon;

my @tests = (
    # [$input, $expected_output, $should_die]
    ['0000-00-00 00:00:00', '0000-00-00', 1],
    ['2015-01-13 13:13:13', '2015-01-12', 0],
    ['2015-01-01 13:13:13', '2014-12-29', 0],
    ['20150101131313', '2014-12-29', 0],
);

Test::More::plan(tests => scalar(@tests));

for my $test (@tests) {
    my ($input, $expected_output, $should_die) = @$test;

    my $name = "str_round_week('$input')";
    if ($should_die) {
        dies_ok { str_round_week($input) } "$name should die";
    } else {
        is(str_round_week($input), $expected_output, "$name == '$expected_output'");
    }
}
