#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More;
use Test::MockTime qw/:all/;

use Yandex::TimeCommon;

# Функция today не имеет параметров. Игнорирует всё, что ей передают и возвращает сегодняшнюю дату.
my @args = (
    \1234,
    {},
    [],
    'abc',
    '0x010',
    undef,
    time,
    0,
    112222,
);

set_fixed_time(1363185123);
foreach my $arg (@args) {
    is(today($arg), '20130313');
}
set_fixed_time(1363200000);
foreach my $arg (@args) {
    is(today($arg), '20130313');
}

done_testing();
