#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More;
use Test::Exception;
use Test::MockTime qw/:all/;

use Time::Local;
use Yandex::TimeCommon;

my @args = (
    \1234,
    {},
    [],
    'abc',
    '0x010',
    time,
    0,
    112222,
    '0000-00-00',
    '00000000',
    '2013/03/13',
);
foreach my $arg (@args) {
    dies_ok { tomorrow($arg) };
}

set_fixed_time(1363185123);
is(tomorrow(), '20130314'); # при вызове без параметров, возвращает "завтра" от "сегодня"
restore_time();

is(tomorrow('20130313'),   '20130314'); # возвращает "завтра" от переданной даты
is(tomorrow('2013-03-13'), '20130314');

set_fixed_time(timelocal(0,0,21,26,10-1,2014-1900));
is(tomorrow(), '20141027'); # переход на зимнее время

done_testing();
