#!/usr/bin/perl -w

# $Id$
# Юнит тест для функций ts_get_borders, ts_get_hour_borders, ts_get_day_borders, ts_get_week_borders, ts_get_month_borders, ts_get_year_borders

use strict;
use warnings;

use Test::More;
use Test::Exception;
use Test::MockTime qw/:all/;
use POSIX qw(tzset);

use Yandex::TimeCommon;

my $verbose = 0;    # Показывать человеко-понятную информацию во время теста

# Устанавливаем timezone UTC, для лучшего восприятия числовых констант в сравнениях.
$ENV{TZ} = 'UTC0';
tzset;

my $time1 = 1363181614; # Wed Mar 13 13:33:34 2013
my $time2 =  876543210; # Sat Oct 11 04:13:30 1997
my $time3 = 1234567890; # Fri Feb 13 23:31:30 2009

#   [dateagg, start border, end border]
my @tests1 = (
    ['hour',  1363179600, 1363183199],
    ['day',   1363132800, 1363219199],
    ['week',  1362960000, 1363564799],
    ['month', 1362096000, 1364774399],
    ['year',  1356998400, 1388534399],
);
my @tests2 = (
    ['hour',  876542400,  876545999],
    ['day',   876528000,  876614399],
    ['week',  876096000,  876700799],
    ['month', 875664000,  878342399],
    ['year',  852076800,  883612799],
);
my @tests3 = (
    ['hour',  1234566000, 1234569599],
    ['day',   1234483200, 1234569599],
    ['week',  1234224000, 1234742399],
    ['month', 1233446400, 1235865599],
    ['year',  1230768000, 1262303999],
);

sub test_set ($@)
{
    my ($time, @tests) = @_;
    my ($b1, $b2);
    foreach my $test (@tests) {
        ($b1, $b2) = ts_get_borders($time, @$test[0]);
        is($b1, @$test[1]);
        is($b2, @$test[2]);
        if ($verbose) {
            print STDERR '-' x 60, "\n";
            print STDERR @$test[0], "\t", scalar localtime($b1), "\t\t", $b1, "\n";
            print STDERR @$test[0], "\t", scalar localtime($b2), "\t\t", $b2, "\n";
            print STDERR '-' x 60, "\n";
        }
    }
}

test_set($time1, @tests1);
test_set($time2, @tests2);

throws_ok { ts_get_borders(time, 'bad format') } qr/Unknown dateagg/, 'Unknow dateagg';
{
    local $SIG{__WARN__} = sub { };
    dies_ok { ts_get_borders(time, undef ) } 'Unknow dateagg';
    dies_ok { ts_get_borders(time        ) } 'Unknow dateagg';
}

set_fixed_time($time3);
# feature - undef argument equals to "time"
test_set(undef, @tests3);
restore_time();

SKIP: { # Не реализована проверка аргументов. Хотелось бы, чтобы функция умирала, а не отдавала какой-то (не всегда адекватный) результат.
    my @dateaggs = (
        'hour',
        'day',
        'week',
        'month',
        'year',
    );
    my @args = (
        \1234,
        {},
        [],
        'abc',
        '0x010',
    );

    skip 'Argument checking is not yet implemented', @dateaggs * @args if 1;

    foreach my $dateagg (@dateaggs) {
        foreach my $arg (@args) {
            dies_ok { ts_get_borders($arg, $dateagg) } 'Argument must be a valid time';
        }
    }
}

done_testing();
