#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More;
use Test::Deep;
use Test::Exception;

use Yandex::TimeCommon;

my $time1 = 1330416000; # Tue Feb 28 12:00:00 2012
my $time2 = 1330675200; # Fri Mar  2 12:00:00 2012
my $time3 = 1362038400; # Thu Feb 28 12:00:00 2013
my $time4 = 1362211200; # Sat Mar  2 12:00:00 2013
my $time5 = 1356897600; # Mon Dec 31 00:00:00 2012
my $time6 = 1356984000; # Tue Jan  1 00:00:00 2013

my $res1 = ['20120228', '20120229', '20120301', '20120302'];
my $res2 = ['20130228', '20130301', '20130302'];
my $res3 = ['20121231', '20130101'];
my $res4 = ['20121231'];

is(ts_get_distinct_dates(1333333333, 1222222222),                    (), "ts_get_\tend < start");
is(get_distinct_dates('2013-02-01 10:09:08', '2012-09-20 22:09:08'), (), "get_\tend < start");

cmp_deeply($res1, [ ts_get_distinct_dates($time1, $time2)                            ], "ts_get_\ttest set 1" );
cmp_deeply($res1, [ get_distinct_dates('2012-02-28 15:41:10', '2012-03-02 01:00:05') ], "get_\ttest set 1" );
cmp_deeply($res2, [ ts_get_distinct_dates($time3, $time4)                            ], "ts_get_\ttest set 2" );
cmp_deeply($res2, [ get_distinct_dates('2013-02-28 15:41:10', '2013-03-02 01:00:05') ], "get_\ttest set 2" );
cmp_deeply($res3, [ ts_get_distinct_dates($time5, $time6)                            ], "ts_get_\ttest set 3" );
cmp_deeply($res3, [ get_distinct_dates('2012-12-31 15:41:10', '2013-01-01 00:00:00') ], "get_\ttest set 3" );
cmp_deeply($res4, [ ts_get_distinct_dates($time5, $time6 - 1)                        ], "ts_get_\ttest set 4" );
cmp_deeply($res4, [ get_distinct_dates('2012-12-31 00:00:00', '2012-12-31 23:59:59') ], "get_\ttest set 4" );

my @args = (
    \1234,
    {},
    [],
    'abc',
    '0x010',
    undef,
);

foreach my $arg1 (@args) {
    foreach my $arg2 (@args) {
        dies_ok { get_distinct_dates($arg1, $arg2) } 'Argument must be a valid time in get_distinct_dates';
        
        SKIP: { # Не реализована проверка входных аргументов: если первый аргумент не число - возвращает список от 1970 года до второго числа или только 19700101
            skip 'Argument checking is not yet implemented in ts_get_distinct_dates', 1 if 1;
            dies_ok { ts_get_distinct_dates($arg1, $arg2) } 'Argument must be a valid time in ts_get_distinct_dates';
        }
    }
}

done_testing();
