#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More;
use Test::Exception;
use Test::MockTime qw/:all/;
use POSIX qw(tzset);

use Yandex::TimeCommon;

# Устанавливаем timezone UTC, для лучшего восприятия числовых констант в сравнениях.
$ENV{TZ} = 'UTC0';
tzset;

my $time = time;
is(ts_round($time,      'sec'),   $time);
is(ts_round(1363181614, 'sec'),   1363181614);
is(ts_round(10,         '5min'),  0);
is(ts_round(333,        '5min'),  300);
is(ts_round(1363170081, '5min'),  1363170000);
is(ts_round(2500,       'hour'),  0);
is(ts_round(4444,       'hour'),  3600);
is(ts_round(1363149158, 'hour'),  1363147200);
is(ts_round(1577899540, 'hour'),  1577898000);
is(ts_round(75691,      'day' ),  0);
is(ts_round(99999,      'day' ),  86400);
is(ts_round(1363132801, 'day' ),  1363132800);
is(ts_round(1577899540, 'day' ),  1577836800);
is(ts_round(400000,     'week'),  345600);  # 4 дня, т.к. 1ая неделя начинается с четверга
is(ts_round(1362614400, 'week'),  1362355200);
is(ts_round(1578591240, 'week'),  1578268800);
is(ts_round(1838400,    'month'), 0);
is(ts_round(4838400,    'month'), 2678400);
is(ts_round(1363181614, 'month'), 1362096000);
is(ts_round(1588699540, 'month'), 1588291200);
is(ts_round(1363181614, 'year'), 1356998400);

throws_ok { ts_round(time, 'bad format') } qr/Unknown dateagg/, 'Unknow dateagg';
{
    local $SIG{__WARN__} = sub { };
    dies_ok { ts_round(time, undef ) } 'Unknow dateagg';
    dies_ok { ts_round(time        ) } 'Unknow dateagg';
}

SKIP: { # Не реализована проверка аргументов.
        # при округлении до секунд, просто возвращается аргумент (фича?)
        # при округлении до других уровней - не умирает и не возвращает ничего вменяемого
    my @dateaggs = (
        'sec',
        '5min',
        'hour',
        'day',
        'week',
        'month',
    );
    my @args = (
        \1234,
        {},
        [],
        'abc',
        '0x010',
    );
    
    skip 'Argument checking is not yet implemented.', @args * @dateaggs + 1 if 1;

    foreach my $dateagg (@dateaggs) {
        foreach my $arg (@args) {
            dies_ok { ts_round($arg, $dateagg ) } 'First argument must be a valid time';
        } 
    }
    # Вынесено отдельно, потому что для других уровней округления - undef воспринимается как time
    dies_ok { ts_round(undef, 'sec' ) } 'First argument must be a valid time';
}

SKIP: { # Вообще не хорошо, что функция ts_round для разных уровней аггрегации ведет себя по-разному:
        # 0 до секунд или 5 минут, - округляется до нуля;
        # а при округлении до часов или дней, недель, месяцев - округляет от текущего времени
    skip 'different function behavior for the zero time argument', 5 if 1;

    # если чинить "часы, дни, недели, месяцы"
    is(ts_round(0, 'hour'),  0);
    is(ts_round(0, 'day'),   0);
    is(ts_round(0, 'month'), 0);
    # Не уверен, что именно 0 здесь должен возвращаться, time=0 - это четверг. и куда его округлять (вверх или вниз) - не очевидно
    # см. комментарий к блоку SKIP ниже.
    is(ts_round(0, 'week'),  0);

    # или если чинить секунды и округление до 5 минут
    set_fixed_time(1363185123);
    is(ts_round(0, 'sec'),   1363185123);
    is(ts_round(0, '5min'),  1363185000);
    restore_time();
}

SKIP: { # Странное поведение
        # из-за особенностей точки отсчета (первый день - четверг), округление малых величин дает отрицательный результат
        # А хотелось бы 0, как возвращают все остальные функции, но это лишено смысла.
    skip 'the negative result of rounding to week values less than 4 days', 1 if 1;
    is(ts_round(300000, 'week' ),  0); # == -259200
}

done_testing();
