#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More;
use Test::Exception;
use Test::MockTime qw/:all/;
use POSIX qw(tzset);

use Yandex::TimeCommon;

# Проверка на числах в ts_round.t

# Устанавливаем timezone UTC, для лучшего восприятия числовых констант в сравнениях.
$ENV{TZ} = 'UTC0';
tzset;

SKIP: { # Не реализована проверка аргументов
    skip 'Argument checking is not yet implemented', 5 if 1;

    dies_ok { ts_round_year(\1234  ) } 'Argument must be a valid time';
    dies_ok { ts_round_year({}     ) } 'Argument must be a valid time';
    dies_ok { ts_round_year([]     ) } 'Argument must be a valid time';
    dies_ok { ts_round_year('abc'  ) } 'Argument must be a valid time';
    dies_ok { ts_round_year('0x010') } 'Argument must be a valid time';
}

is(ts_round_year(10050011),   0);
is(ts_round_year(39999999),   31536000);    # 1 год
is(ts_round_year(1363181614), 1356998400);
is(ts_round_year(1577899540), 1577836800);

set_fixed_time(1363185123);
is(ts_round_year(undef), 1356998400);   # feature, вместо undef берется time
is(ts_round_year(),      1356998400);
restore_time();

done_testing();
