#!/usr/bin/perl -w

# $Id$
# Юнит тесты для функций ts_to_str и ts_to_tbl_suffix

use strict;
use warnings;

use Test::More;
use Test::Exception;
use POSIX qw(tzset);

use Yandex::TimeCommon;

# Устанавливаем timezone UTC, для лучшего восприятия числовых констант в сравнениях. Ну и чтобы тест не сломался, если будет выполняться на другой timezone.
$ENV{TZ} = 'UTC0';
tzset;

my $time1 = 1363181614; # Wed Mar 13 13:33:34 2013
my $time2 =  876543210; # Sat Oct 11 04:13:30 1997
my $time3 = 1234567890; # Fri Feb 13 23:31:30 2009

#   [agg lvl, timestamp, result]
my @tests = (
    ['hour',  $time1, '2013031313'],
    ['hour',  $time2, '1997101104'],
    ['hour',  $time3, '2009021323'],
    ['day',   $time1, '20130313'],
    ['day',   $time2, '19971011'],
    ['day',   $time3, '20090213'],
    ['week',  $time1, '20130313'],
    ['week',  $time2, '19971011'],
    ['week',  $time3, '20090213'],
    ['month', $time1, '201303'],
    ['month', $time2, '199710'],
    ['month', $time3, '200902'],
    ['year',  $time1, '2013'],
    ['year',  $time2, '1997'],
    ['year',  $time3, '2009'],
    [undef,   $time1, '20130313'],
    [undef,   $time2, '19971011'],
    [undef,   $time3, '20090213'],
);

my %suffix = (
    hour => 'hourly',
    day => 'daily',
    week => 'weekly',
    month => 'monthly',
    year => 'yearly',
);

foreach my $test (@tests) {
    is(ts_to_str(        @$test[1], @$test[0] ), @$test[2]);
    is(ts_to_tbl_suffix( @$test[1], @$test[0] ), $suffix{@$test[0] || 'day'} . '_' . @$test[2]);
}

throws_ok { ts_to_str(time, 'bad format') } qr/Unknown aggregate level/, 'Unknown aggregate level';
is(ts_to_str(1363181614),'20130313');
throws_ok { ts_to_tbl_suffix(time, 'bad format') } qr/Unknown aggregate level/, 'Unknown aggregate level';
is(ts_to_tbl_suffix(1363181614),'daily_20130313');

SKIP: { # Не реализована проверка аргументов. Хотелось бы, чтобы функция умирала, а не отдавала результат для 0, кидая при этом warning
    my @dateaggs = (
        'hour',
        'day',
        'week',
        'month',
        'year',
    );
    my @args = (
        \1234,
        {},
        [],
        'abc',
        '0x010',
        undef,
    );

    skip 'Argument checking is not yet implemented', @dateaggs * @args * 2 if 1;

    foreach my $dateagg (@dateaggs) {
        foreach my $arg (@args) {
            dies_ok { ts_to_str($arg, $dateagg);        } 'Argument must be a valid time';
            dies_ok { ts_to_tbl_suffix($arg, $dateagg); } 'Argument must be a valid time';
        }
    }
}

done_testing();