#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More;
use Test::Exception;
use POSIX qw(tzset);

use Yandex::TimeCommon;

# Устанавливаем timezone UTC
$ENV{TZ} = 'UTC0';
tzset;

my $time1 = 1363181614; # Wed Mar 13 13:33:34 2013
my $time2 =  876543210; # Sat Oct 11 04:13:30 1997
my $time3 = 1234567890; # Fri Feb 13 23:31:30 2009

my @tests = (
    #timestamp, format, result
    [$time1, undef,               '2013-03-13 13:33:34'],
    [$time2, undef,               '1997-10-11 04:13:30'],
    [$time3, undef,               '2009-02-13 23:31:30'],
    [$time1, '%Y-%m-%d %H:%M:%S', '2013-03-13 13:33:34'],
    [$time2, '%Y-%m-%d %H:%M:%S', '1997-10-11 04:13:30'],
    [$time3, '%Y-%m-%d %H:%M:%S', '2009-02-13 23:31:30'],
    [$time1, '%y/%m/%d %k:%M',    '13/03/13 13:33'],
    [$time2, '%y/%m/%d %k:%M',    '97/10/11  4:13'],
    [$time3, '%y/%m/%d %k:%M',    '09/02/13 23:31'],
);

foreach my $test (@tests) {
    is(unix2human(@$test[0], @$test[1]), @$test[2]);
}

SKIP: { # Не реализована проверка принимаемого $time. Хотелось бы, чтобы функция умирала, а не отдавала какой-то результат, кидая при этом warning
    my @args = (
        \1234,
        {},
        [],
        'abc',
        '0x010',
        undef,
    );

    skip 'Argument checking is not yet implemented', scalar @args if 1;

    foreach my $arg (@args) {
        dies_ok { unix2human($arg, '%y/%m/%d'); } 'Argument must be a valid time';
    }
}

done_testing();
