#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More;
use Test::Exception;
use Test::MockTime qw/:all/;

use Yandex::TimeCommon;

my @args = (
    \1234,
    {},
    [],
    'abc',
    '0x010',
    time,
    0,
    112222,
    '0000-00-00',
    '00000000',
    '2013/03/13',
);
foreach my $arg (@args) {
    dies_ok { yesterday($arg) };
}

set_fixed_time(1363185123);
is(yesterday(), '20130312');    # при вызове без параметров возвращает "вчера" от "сегодня"
restore_time();

is(yesterday('20130313'),   '20130312');    # возвращает "вчера" от переданной даты
is(yesterday('2013-03-13'), '20130312');

done_testing();
