#!/usr/bin/perl -w

# $Id$

=head1 NAME

    check_db_schema.pl

=head1 DESCRIPTION

    Отправляет письмо про расхождения между наблюдаемой схемой БД и тем, что записано в db_schema

=head1 COMMENTS


=cut

use strict;

use FindBin qw/$Bin/;
use lib "$Bin";

use Getopt::Long;
use Sys::Hostname;
use Encode;

use Yandex::Shell;
use Yandex::SendMail;

use Data::Dumper;

use utf8;
use open ':std' => ':utf8';


my ($email_to, $email_from);

Getopt::Long::Configure("pass_through");
GetOptions( 
    'h|help' => \&usage,
    'email-to=s' => \$email_to,
    'email-from=s' => \$email_from,
) || exit(1);

die "--email-to <email> required" unless $email_to;
$email_from ||= $email_to;
$Yandex::SendMail::ENVELOPE_SENDER = $email_from;

$ENV{PATH} = "/usr/local/bin:/usr/bin:/bin:/usr/local/sbin:/usr/sbin:/sbin";
my $report = yash_qx("db_schema.pl --no-svn ".join(" ", @ARGV));
$report = Encode::decode_utf8($report);
$report =~ /^\*\*\*\s*\n(.*?)\n\*\*\*\s*\n*(.*)$/s;
my ($header, $diff) = ($1, $2);

exit if !$diff;

my @files = $diff =~ /^===([^=]\S+)$/gm;
my $diff_cnt = scalar( @files );
 
my $host = hostname();

my $subj = "db_schema: $diff_cnt diffs ($host)";
my $message = "Или файлы, или БД требуют обновления.";
my $mail_content = "host:      $host\n$header\ndiffs: $diff_cnt\n\n$message\n\n$diff\n";

Yandex::SendMail::sendmail($email_to, $email_from, $subj, \$mail_content);

exit; 

