#!/usr/bin/perl -w

# $Id$

=pod

    создание таблиц по схеме   

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;

use Test::More;
use Test::Exception;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use Yandex::DBSchema;
$Yandex::DBSchema::DB_SCHEMA_ROOT = "$Bin/db_schema";

use constant PPC => 'ppc';

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;
#$Yandex::DBTools::QUERIES_LOG = 'dbtools_queries.log';

dies_ok { 
    local get_dbh(UT)->{PrintError} = 0; 
    get_one_field_sql(PPC, "show create table campaigns") 
} "nonexistent table";

# создаем таблицу
lives_ok { create_table_by_schema(PPC, "ppc.campaigns") } "create table";

# проверяем, что создалась 
lives_ok { get_one_field_sql(PPC, "show create table campaigns") } "table created";

# повторно таблицу создать нельзя
dies_ok { 
    local get_dbh(UT)->{PrintError} = 0; 
    create_table_by_schema(PPC, "ppc.campaigns");
} "table already exists";

# проверяем if_not_exists: 
#   с неправильным параметром -- должно падать
dies_ok { create_table_by_schema(PPC, "ppc.campaigns", if_not_exist => 1) } "incorrect named param";
#   с правильным параметром -- работать нормально 
lives_ok { create_table_by_schema(PPC, "ppc.campaigns", if_not_exists => 1) } "if_not_exists";

# проверяем like, создаем вторую таблицу: 
#   с неправильным параметром -- должно падать
dies_ok { create_table_by_schema(PPC, "ppc.campaigns_2", LIKE => "campaigns") } "incorrect named param";
#   с правильным параметром -- работать нормально 
lives_ok { create_table_by_schema(PPC, "ppc.campaigns_2", like => "campaigns") } "create table like";

# проверяем, что создалась
lives_ok { get_one_field_sql(PPC, "show create table campaigns_2") } "table created";

# создаём таблицу с партишенами и другим ENGINE'ом
lives_ok { create_table_by_schema(PPC, "ppc.bs_order_target_stat", engine => 'MyISAM') } "create partitioned table (bs_order_target_stat) with another ENGINE";
# и проверяем, что создалась
lives_ok { get_one_field_sql(PPC, "show create table bs_order_target_stat") } "partitioned table (bs_order_target_stat) successfully created";

# удаляем все таблицы, чтобы не мешали следующим тестам 
lives_ok { do_sql(PPC, "drop table campaigns") } "drop table";
lives_ok { do_sql(PPC, "drop table campaigns_2") } "drop table";
lives_ok { do_sql(PPC, "drop table bs_order_target_stat") } "drop table bs_order_target_stat";

done_testing;
