#!/usr/bin/perl

# вспомогательный скрипт, создание необходимых таблиц

use strict;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::DBUnitTest qw/:all/;

use utf8;

%Yandex::DBShards::SHARD_KEYS = (
    ClientID => {
        table => 'shard_client_id',
        shard_key => 'shard',
        not_zero  => 1,
    },
    uid => {
        table => "shard_uid",
        chain_key => "ClientID",
    },
    login => {
        type => 'str',
        table => "shard_login",
        chain_key => "uid",
    },
    blogin => {
        type => 'bin',
        table => "shard_blogin",
        chain_key => "uid",
    },
    cid => {
        table => "shard_inc_cid",
        autoinc => 1,
        chain_key => "ClientID",
    },
    bids_id => {
        table => "inc_bids_id",
        autoinc => 1,
    }
);
$Yandex::DBShards::SHARD_DB = UT;

create_table(UT, 'shard_client_id' => 'ClientID:int:pk', 'shard:int:not_null');
create_table(UT, 'shard_uid' => 'uid:int:pk', 'ClientID:int:not_null');
create_table(UT, 'shard_login' => 'login:pk', 'uid:int:not_null');
create_table(UT, 'shard_blogin' => 'blogin:varbinary(100):pk', 'uid:int:not_null');
create_table(UT, 'shard_inc_cid' => 'cid:int:pk:auto', 'ClientID:int:not_null');
create_table(UT, 'inc_bids_id' => 'bids_id:int:pk:auto');
