#!/usr/bin/perl -w

use strict;
use warnings;

use Carp;
use Test::More;
use Test::Exception;

use Data::Dumper;
use Encode;
use Yandex::DBShards;

BEGIN {
    use FindBin qw/$Bin/;
    require "$Bin/_prepare.pl";
};
use utf8;

$SIG{__WARN__} = \&Carp::croak;

*clear_autoinc_table = \&Yandex::DBShards::clear_autoinc_table;

# errors
dies_ok {clear_autoinc_table();} "no key";
dies_ok {clear_autoinc_table(undef);} "no key";
dies_ok {clear_autoinc_table('asdfewr');} "no key";
dies_ok {clear_autoinc_table('bids_id', asdf => 234);} "incorrect options";
dies_ok {clear_autoinc_table('ClientID');} "incorrect key";
dies_ok {clear_autoinc_table('uid');} "incorrect key";

my $n = 1000;
for my $cz (100, 10, 3, 2, 1) {
    local $Yandex::DBShards::CHUNK_SIZE = $cz;
    do_sql(UT, "DELETE FROM inc_bids_id limit $n");
    do_mass_insert_sql(UT, "INSERT INTO inc_bids_id (bids_id) VALUES %s", [map {[$_]} 1..$n]);
    Yandex::DBShards::clear_all_autoinc_tables();
    my ($min, $max, $cnt) = get_one_line_array_sql(UT, "SELECT min(bids_id), max(bids_id), count(*) FROM inc_bids_id");
    cmp_ok($max, '==', $n, "ok max for chunk_size=$cz");
    cmp_ok($min, '<=', $n-$cz, "ok min for chunk_size=$cz");
    cmp_ok($min, '>=', $n-2*$cz, "ok min for chunk_size=$cz");
    cmp_ok($cnt, '>=', $cz, "ok cnt for chunk_size=$cz");
    cmp_ok($cnt, '<=', 2*$cz+1, "ok cnt for chunk_size=$cz");
}

do_sql(UT, "TRUNCATE TABLE inc_bids_id");
lives_ok {clear_autoinc_table('bids_id');} "clear empty table";

done_testing;
