#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More tests => 21;
use Test::Exception;

use Data::Dumper;
use Encode;

use utf8;

BEGIN {
    use FindBin qw/$Bin/;
    require "$Bin/_prepare.pl";
};

sub get {
    return get_one_field_sql(UT, @_);
}
sub gets {
	return get_one_column_sql(UT, @_);
}

# uid
save_shard(uid => 1, ClientID => 1);
delete_shard(uid => 1);
is(get("SELECT ClientID FROM shard_uid WHERE uid = ?", 1), undef, "no shard for uid 1");

save_shard(uid => [2,3], ClientID => 2);
delete_shard(uid => 2);
is(get(["SELECT uid FROM shard_uid", where=>{uid=>[2,3]}]), 3, "deleted one shard of 2 users (1)");

save_shard(uid => 2, ClientID => 3);
delete_shard(uid => 3);
is(get(["SELECT ClientID FROM shard_uid", where=>{uid=>[2,3]}]), 3, "deleted one shard of 2 users (2)");

#cid
save_shard(cid => 1, ClientID => 1);
delete_shard(cid => 1);
is(get("SELECT ClientID FROM shard_inc_cid WHERE cid = ?", 1), undef, "no shard for cid 1");

save_shard(cid => [2,3], ClientID => 2);
delete_shard(cid => 2);
is(get(["SELECT cid FROM shard_inc_cid", where=>{cid=>[2,3]}]), 3, "deleted one shard of 2 campaigns (1)");

save_shard(cid => 2, ClientID => 3);
delete_shard(cid => 3);
is(get(["SELECT ClientID FROM shard_inc_cid", where=>{cid=>[2,3]}]), 3, "deleted one shard of 2 campaigns (2)");

# ClientID
# Удаление одного клиента из шардов без удалений из других таблиц
save_shard(ClientID => 10, shard => 1);
save_shard(uid => 1, ClientID => 10);
delete_shard(ClientID => 10);
is(get("SELECT shard FROM shard_client_id WHERE ClientID = ?", 10), undef, "delete shard for ClientID 1");
is(get("SELECT uid FROM shard_uid WHERE ClientID = ?", 10), 1, "delete shard for ClientID 2");

# Удаление нескольких клиента из шардов без удалений из других таблиц
save_shard(ClientID => 10, shard => 1);
save_shard(ClientID => 20, shard => 2);
save_shard(uid => 1, ClientID => 10);
save_shard(uid => 2, ClientID => 20);
delete_shard(ClientID => [10,20]);
is(get(["SELECT shard FROM shard_client_id", where=>{ClientID=>[10,20]}]), undef, "delete shards for ClientID's 1");
is(get(["SELECT uid FROM shard_uid", where=>{ClientID=>10}]), 1, "delete shards for ClientID's 2");
is(get(["SELECT uid FROM shard_uid", where=>{ClientID=>20}]), 2, "delete shards for ClientID's 3");

# Удаление одного клиента из шардов со всеми удалениями из других таблиц
save_shard(ClientID => 10, shard => 1);
save_shard(uid => 1, ClientID => 10);
save_shard(cid => [1,2], ClientID => 10);
save_shard(cid => [3,4], ClientID => 20);
delete_shard(ClientID => 10, recursive=>1);
is(get("SELECT shard FROM shard_client_id WHERE ClientID = ?", 10), undef, "delete shard recursively for ClientID 1");
is(get("SELECT uid FROM shard_uid WHERE ClientID = ?", 10), undef, "delete shard recursively for ClientID 2");
is(get("SELECT cid FROM shard_inc_cid WHERE ClientID = ?", 10), undef, "delete shard recursively for ClientID 3");
is(get("SELECT count(*) FROM shard_inc_cid WHERE ClientID = ?", 20), 2, "delete shard recursively for ClientID 4");

# Удаление нескольких клиента из шардов со всеми удалениями из других таблиц
save_shard(ClientID => 10, shard => 1);
save_shard(ClientID => 20, shard => 2);
save_shard(ClientID => 30, shard => 3);
save_shard(uid => 1, ClientID => 10);
save_shard(uid => 2, ClientID => 20);
save_shard(uid => 3, ClientID => 30);
save_shard(cid => [1,2], ClientID => 10);
save_shard(cid => [3,4], ClientID => 20);
save_shard(cid => [5,6], ClientID => 30);
delete_shard(ClientID => [10,20], recursive=>1);
is(get(["SELECT shard FROM shard_client_id", where=>{ClientID=>[10,20]}]), undef, "delete shards recursively for ClientID's 1");
is(get(["SELECT uid FROM shard_uid", where=>{ClientID=>[10,20]}]), undef, "delete shards recursively for ClientID's 2");
is(get(["SELECT cid FROM shard_inc_cid", where=>{ClientID=>[10,20]}]), undef, "delete shards recursively for ClientID's 3");
is(get("SELECT shard FROM shard_client_id WHERE ClientID = ?", 30), 3, "delete shards recursively for ClientID's 4");
is(get("SELECT uid FROM shard_uid WHERE ClientID = ?", 30), 3, "delete shards recursively for ClientID's 5");
is(get("SELECT count(*) FROM shard_inc_cid WHERE ClientID = ?", 30), 2, "delete shards recursively for ClientID's 6");

