#!/usr/bin/perl -w

use strict;
use warnings;

use List::MoreUtils qw/uniq/;

use Test::More;
use Test::Exception;
use Test::Deep;

use Data::Dumper;
use Encode;

use utf8;

BEGIN {
    use FindBin qw/$Bin/;
    require "$Bin/_prepare.pl";
};

sub get {
    return get_one_field_sql(UT, @_);
}

dies_ok {get_shard(asfasdf => 10)};
dies_ok {get_shard(bids_id => 10)};
dies_ok {get_shard(ClientID => "adsf")};

is(get_shard(ClientID => 10), undef);
is(get_shard(ClientID => undef), undef);
cmp_deeply(get_shard_multi(uid => [10, undef], 'ClientID'), {10 => undef});

# ClientID

save_shard(ClientID => 10, shard => 1);
is(get_shard(ClientID => 10), 1);

save_shard(ClientID => 10, shard => 2);
is(get_shard(ClientID => 10), 2);

is(get_shard(ClientID => 11), undef);

save_shard(ClientID => 11, shard => 1);
is(get_shard(ClientID => 10), 2);

cmp_deeply(get_shard_multi(ClientID => [10, 11, 12]), {10 => 2, 11 => 1, 12 => undef});

# uid
save_shard(uid => 20, ClientID => 10);
save_shard(uid => 21, ClientID => 11);
is(get_shard(uid => 20, 'ClientID'), 10, 'get_shard with chain key');
is(get_shard(uid => 21, 'ClientID'), 11, 'get_shard with chain key2');
cmp_deeply(get_shard_multi(uid => [20, 21, 23]), {20 => 2, 21 => 1, 23 => undef});
cmp_deeply(get_shard_multi(uid => [20, 21, 23], 'ClientID'), {20 => 10, 21 => 11, 23 => undef});

# login
save_shard(login => 'zhurs', uid => 20);
is(get_shard(login => 'zhurs'), 2);
is(get_shard(login => 'zhurs', 'ClientID'), 10);
cmp_deeply(get_shard_multi(login => ['Zhurs'], 'ClientID'), {Zhurs => 10});

save_shard(login => 'Zhurs1', uid => 21);
cmp_deeply(get_shard_multi(login => ['Zhurs1', 'zhUrs1'], 'ClientID'), {Zhurs1 => 11, zhUrs1 => 11});

save_shard(login => 'zhurs2', uid => 21);
is(get_shard(login => 'zhurs2'), 1);

# blogin
save_shard(blogin => 'Zhurs1', uid => 21);
cmp_deeply(get_shard_multi(blogin => ['Zhurs1', 'zhUrs1'], 'ClientID'), {Zhurs1 => 11, zhUrs1 => undef});


done_testing;

