#!/usr/bin/perl -w

use strict;
use warnings;

use List::MoreUtils qw/uniq/;

use Test::More;
use Test::Exception;
use Test::Deep;

use Data::Dumper;
use Encode;

use utf8;

BEGIN {
    $Yandex::DBUnitTest::NO_CHANGELING = 1;
    use FindBin qw/$Bin/;
    require "$Bin/_prepare.pl";
};

%Yandex::DBTools::DB_CONFIG = (
    utf8 => 1,
    port => 3306,
    user => 'root',
    connect_timeout => 4,
    CHILDS => {
        ppc => {
            CHILDS => {
                1 => {
                    host => 'ppcdata1.yandex.ru',
                    CHILDS => {
                        '_' => {},
                        'heavy' => {},
                    }
                },
                2 => {
                    host => 'ppcdata2.yandex.ru',
                    CHILDS => {
                        '_' => {},
                        'heavy' => {},
                    }
                },
            }
        },
        ppcdict => {
            host => 'ppcdict.yandex.ru'
        }
    }
    );

sub get {
    return get_one_field_sql(UT, @_);
}
sub t {
    return Yandex::DBShards::get_shard_dbnames($_[0], $_[1], $_[2], $_[3]);
}

# ClientID
save_shard(ClientID => 10, shard => 1);
save_shard(ClientID => 11, shard => 2);

cmp_deeply(t('ppc', undef, ClientID => 10), {dbnames => bag('ppc:1'), key => 'ClientID', val => 10,
                                             dbname_vals => {'ppc:1' => [10]}});
cmp_deeply(t('ppc', undef, ClientID => 11), {dbnames => bag('ppc:2'), key => 'ClientID', val => 11,
                                             dbname_vals => {'ppc:2' => [11]}});
cmp_deeply(t('ppc', undef, ClientID => []), {dbnames => bag(), key => 'ClientID', val => [],
                                             dbname_vals => {}});
cmp_deeply(t('ppc', undef, ClientID => [10,11]), {dbnames => bag('ppc:1', 'ppc:2'), key => 'ClientID', val => [10,11],
                                             dbname_vals => {'ppc:1' => [10], 'ppc:2' => [11]}});

cmp_deeply(t('ppc', 'heavy', ClientID => 10), {dbnames => bag('ppc:1:heavy'), key => 'ClientID', val => 10,
                                               dbname_vals => {'ppc:1:heavy' => [10]}});
cmp_deeply(t('ppc', 'heavy', ClientID => 11), {dbnames => bag('ppc:2:heavy'), key => 'ClientID', val => 11,
                                               dbname_vals => {'ppc:2:heavy' => [11]}});
cmp_deeply(t('ppc', 'heavy', ClientID => []), {dbnames => bag(), key => 'ClientID', val => [],
                                               dbname_vals => {}});

cmp_deeply(t('ppc', 'heavy', shard => []), {dbnames => bag(), key => 'shard', val => [],
                                            dbname_vals => {}});
cmp_deeply(t('ppc', 'heavy', shard => 'all'), {dbnames => bag('ppc:1:heavy', 'ppc:2:heavy'), key => 'shard', val => 'all', 
                                               dbname_vals => {'ppc:1:heavy'=>undef, 'ppc:2:heavy'=>undef}});
cmp_deeply(t('ppc', 'heavy', shard => [1,2]), {dbnames => bag('ppc:1:heavy', 'ppc:2:heavy'), key => 'shard', val => [1,2],
                                               dbname_vals => {'ppc:1:heavy'=>undef, 'ppc:2:heavy'=>undef}});
cmp_deeply(t('ppc', 'heavy', shard => [1]), {dbnames => bag('ppc:1:heavy'), key => 'shard', val => [1],
                                             dbname_vals => {'ppc:1:heavy'=>undef}});


{
    local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;
    cmp_deeply(t('ppc', undef), {dbnames => bag('ppc:1', 'ppc:2'), key => undef, val => undef,
                                               dbname_vals => {'ppc:1'=>undef, 'ppc:2'=>undef}});

    cmp_deeply(t('ppc', 'heavy'), {dbnames => bag('ppc:1:heavy', 'ppc:2:heavy'), key => undef, val => undef,
                                               dbname_vals => {'ppc:1:heavy'=>undef, 'ppc:2:heavy'=>undef}});

    cmp_deeply(t('ppcdict', undef), {dbnames => bag('ppcdict'), key => undef, val => undef,
                                               dbname_vals => {'ppcdict'=>undef}});
    
}


# фиксируем особенности работы с кешом для случая shard => "all"
is(scalar @{t('ppc', '', shard => 'all')->{dbnames}}, 2, "all shards count, correct value");
$Yandex::DBTools::DB_CONFIG{CHILDS}->{ppc}->{CHILDS}->{3} = {host => 'ppcdata3.yandex.ru'};
is(scalar @{t('ppc', '', shard => 'all')->{dbnames}}, 2, "all shards count, incorrect cached value");
Yandex::DBShards::clear_db_childs_cache();
is(scalar @{t('ppc', '', shard => 'all')->{dbnames}}, 3, "all shards count, correct value after clearing cache");
delete $Yandex::DBTools::DB_CONFIG{CHILDS}->{ppc}->{CHILDS}->{3};


dies_ok {t('ppc', undef)};
dies_ok {t('ppc', 'heavy')};
dies_ok {t('ppcdict', undef)};

dies_ok {t('ppc', undef, shard => 5)};

done_testing();
