#!/usr/bin/perl -w

use strict;
use warnings;

use List::MoreUtils qw/uniq/;

use Test::More;
use Test::Exception;
use Test::Deep;

use Data::Dumper;
use Encode;

use utf8;

BEGIN {
    use FindBin qw/$Bin/;
    require "$Bin/_prepare.pl";
};

sub get {
    return get_one_field_sql(UT, @_);
}

*gv = \&Yandex::DBShards::get_sharded_vals;
*gvm = \&Yandex::DBShards::get_sharded_vals_multi;

dies_ok {gv(ClientID => 12, "asdf")};
dies_ok {gv("adsf" => 12, "login")};
dies_ok {gvm(ClientID => 12, "login")};
dies_ok {gvm(ClientID => [12], "adsf")};
dies_ok {gvm(adsf => [12], "login")};
dies_ok {gvm(login => [12], "ClientID")};
dies_ok {gvm(login => [12], "uid")};


save_shard(ClientID => [1,2], shard => 1);
save_shard(uid => [11,12], ClientID => 1);
save_shard(uid => [21], ClientID => 2);
save_shard(login => 'l11', uid => 11);
save_shard(login => 'l12', uid => 12);
save_shard(login => 'l21', uid => 21);


cmp_deeply(gvm(ClientID => [], "login"), {});
cmp_deeply(gvm(ClientID => [1], "login"), {1 => ["l11", "l12"]});
cmp_deeply(gvm(ClientID => [1,2], "login"), {1 => ["l11", "l12"], 2 => ["l21"]});
cmp_deeply(gvm(ClientID => [1,2], "uid"), {1 => [11, 12], 2 => [21]});
cmp_deeply(gvm(uid => [11], "login"), {11 => ["l11"]});

cmp_deeply(gv(uid => 11, "login"), ["l11"]);

done_testing;

