#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More;
use Test::Exception;

use Data::Dumper;
use Encode;

use utf8;

BEGIN {
    use FindBin qw/$Bin/;
    require "$Bin/_prepare.pl";
};

sub get {
    return get_one_field_sql(UT, @_);
}

# ClientID
dies_ok {save_shard(ClientID => 1, uid => 1);} "incorrect shard_key";
dies_ok {save_shard(ClientID => 1, shard => undef);} "incorrect shard_key";
dies_ok {save_shard(ClientID => 0, shard => 1);} "not_zero field ClientID is zero 1";
dies_ok {save_shard(ClientID => [1,0,3], shard => 1);} "not_zero field ClientID is zero 2";

save_shard(ClientID => 1, shard => 1);
is(get("SELECT shard FROM shard_client_id WHERE ClientID = ?", 1), 1, "good shard for ClientID 1");
save_shard(ClientID => 2, shard => 2);
is(get("SELECT shard FROM shard_client_id WHERE ClientID = ?", 2), 2, "good shard for ClientID 2");
save_shard(ClientID => 1, shard => 3);
is(get("SELECT shard FROM shard_client_id WHERE ClientID = ?", 1), 3, "change shard for ClientID 1");
save_shard(ClientID => 2, ClientID => 1);
is(get("SELECT shard FROM shard_client_id WHERE ClientID = ?", 2), 3, "good shard for ClientID 3");

# uid
dies_ok {save_shard(uid => 1, uid => 1);} "incorrect shard_key";
dies_ok {save_shard(uid => 1, shard => 1);} "incorrect shard_key";
dies_ok {save_shard(uid => 1, ClientID => undef);} "incorrect shard_key";
dies_ok {save_shard(uid => 1, ClientID => 0);} "not_zero field is zero 1";

save_shard(uid => 1, ClientID => 1);
is(get("SELECT ClientID FROM shard_uid WHERE uid = ?", 1), 1, "good shard for uid 1");
save_shard(uid => 2, ClientID => 2);
is(get("SELECT ClientID FROM shard_uid WHERE uid = ?", 2), 2, "good shard for uid 2");
save_shard(uid => 2, ClientID => 1);
is(get("SELECT ClientID FROM shard_uid WHERE uid = ?", 2), 1, "good shard for uid 2");
save_shard(uid => 0, ClientID => 1);
is(get("SELECT ClientID FROM shard_uid WHERE uid = ?", 0), 1, "good shard for uid 0");

# login
save_shard(login => "zhurs", uid => 1);
is(get("SELECT uid FROM shard_login WHERE login = ?", "zhurs"), 1, "good shard for login zhurs");
save_shard(login => "zhurs2", uid => 2);
is(get("SELECT uid FROM shard_login WHERE login = ?", "zhurs2"), 2, "good shard for login zhurs2");
save_shard(login => "zhurs2", uid => 3);
is(get("SELECT uid FROM shard_login WHERE login = ?", "zhurs2"), 3, "good shard for login zhurs2");

# cid
dies_ok {save_shard(cid => 1, shard => 1);} "incorrect shard_key";
dies_ok {save_shard(cid => 1, ClientID => undef);} "incorrect shard_key";
save_shard(cid => 1, ClientID => 1);
is(get("SELECT ClientID FROM shard_inc_cid WHERE cid = ?", 1), 1, "good shard for cid 1");
save_shard(cid => 2, ClientID => 2);
is(get("SELECT ClientID FROM shard_inc_cid WHERE cid = ?", 2), 2, "good shard for cid 2");
save_shard(cid => 2, ClientID => 1);
is(get("SELECT ClientID FROM shard_inc_cid WHERE cid = ?", 2), 1, "good shard for cid 2");

save_shard(cid => [3,4], ClientID => 1);
is(get(["SELECT count(*) FROM shard_inc_cid", WHERE => {cid => [3,4], ClientID => 1}]), 2, "good shard for multisave");

save_shard(uid => 2, ClientID => 3);
save_shard(cid => 1, uid => 2);
is(get(["SELECT ClientID FROM shard_inc_cid", WHERE => {cid => 1}]), 3, "good shard for skip-save");

dies_ok {save_shard(cid => 1, uid => 100);} "no shard info for value";

# bids_id
dies_ok {save_shard(bids_id => 1, uid => 1);} "no shard_key";
dies_ok {save_shard(bids_id => 1, shard => 1);} "no shard_key";
dies_ok {save_shard(bids_id => 1, ClientID => undef);} "no shard_key";

done_testing();
