#!/usr/bin/perl

use strict;
use warnings;

use Test::More;
use Test::Deep;

use Yandex::DBTools;
use Yandex::DBUnitTest;
use Yandex::Trace;

my $trace = Yandex::Trace->new(service => 'ser v', method => 'me:t *\ h');

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

my @queries;
sub sql_work {
    my (@res, @queries);
    local $Yandex::DBTools::QUERIES_LOG = 1;
    no warnings 'redefine';
    local *Yandex::DBTools::_log_query = sub {
        push @queries, $_[1];
    };

    push @res, do_sql(UT, "set character set 'utf8'");
    push @res, do_sql(UT, "create table ct (i int)");
    push @res, do_sql(UT, "insert into ct (i) values (1)");
    push @res, !!exec_sql(UT, "select 1");
    push @res, get_all_sql(UT, "select * from ct");
    push @res, get_all_sql(UT, "/* dfgsdf */ select * from ct");
    push @res, get_all_sql(UT, "/* dfgsdf */select * from ct");
    push @res, get_all_sql(UT, "select/* dfgsdf */ * from ct");
    push @res, get_all_sql(UT, "select /* dfgsdf */ * from ct");
    push @res, get_all_sql(UT, "select * from ct /* dfgsdf */ ");
    push @res, get_all_sql(UT, "select -- \n* from ct /* dfgsdf */ ");
    push @res, do_insert_into_table(UT, "ct", {i=>7});
    push @res, do_delete_from_table(UT, "ct", where => {i => 4});
    push @res, do_mass_insert_sql(UT, "INSERT INTO ct (i) VALUES %s", [[1]]);
    push @res, do_sql(UT, "drop table ct");
    return \@res, \@queries;
}

$Yandex::DBTools::TRACE_COMMENT = 0;
my ($ref_res, $ref_queries) = sql_work();
ok(scalar(@$ref_res) > 10, 'more than 10 etalon tests');
is(scalar(@$ref_res), scalar(@$ref_queries), "number of results equals number of queries in etalon test");
is(scalar(grep {/reqid:/} @$ref_queries), 0, "no reqid in etalon test queries");

$Yandex::DBTools::TRACE_COMMENT = 1;
my ($traced_res, $traced_queries) = sql_work();
is(scalar(@$traced_res), scalar(@$ref_res), "number of etalon results equals number of traced results");
is(scalar(@$traced_res), scalar(@$traced_queries), "number of results equals number of queries in traced test");
cmp_deeply($traced_res, $ref_res, "equivalence of etalon an trased results");
is(scalar(grep {/reqid:\d+:ser_v:me_t____h/} @$traced_queries), scalar(@$traced_queries), "all traced queries matched 'reqid:...' regexp");

$Yandex::DBTools::TRACE_COMMENT_VARS = sub {return {operator => "op", var => "foo */ "}; };
($traced_res, $traced_queries) = sql_work();
is(
    scalar(grep {/reqid:\d+:ser_v:me_t____h:operator=op:var=foo____/} @$traced_queries),
    scalar(@$traced_queries),
    "all traced queries with TRACE_COMMENT_VARS matched 'reqid:...' regexp"
);


# чтобы ошибки не сыпались
$trace->{pid}++;

done_testing;
