#!/usr/bin/perl -w
use strict;
use warnings;

use Test::More;
use Test::Exception;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

my $limit = get_one_field_sql(UT, 'select @@max_allowed_packet');
get_dbh(UT)->{PrintError} = 0;

dies_ok {
    get_one_field_sql(UT, "SELECT 1 -- ".('x' x $limit));
};

my $ret;
lives_ok {
    $ret = get_one_field_sql(UT, "SELECT 132");
};

is($ret, 132);

done_testing;
