#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Yandex::DBTools;

use utf8;

my @tests = (
    # [$sql, $type]
    ['UPDATE campaigns SET sum=0, sum_spent=0, statusBsSynced="No" WHERE cid = 666', 'write'],
    ['REPLACE campaigns SET sum=0, sum_spent=0, statusBsSynced="No" WHERE cid = 666', 'write'],
    ['INSERT IGNORE INTO clients_to_fetch_nds (ClientID) VALUES (777)', 'write'],
    ['INSERT INTO clients_to_fetch_nds SET ClientID = 777', 'write'],
    ['DELETE FROM clients_to_fetch_nds WHERE ClientID = 777', 'write'],
    ['DROP TABLE IF EXISTS bsClientData_tmp_1 RESTRICT', 'write'],
    ['CREATE TABLE bsClientData_tmp_1 AS SELECT * FROM campaigns WHERE cid = 666', 'write'],

    ['SELECT STRAIGHT JOIN * FROM campaigns c INNER JOIN users u ON c.uid = u.uid WHERE c.cid=666', 'read'],
    ['SET SESSION group_concat_max_len = 1000000', 'read'],

    ['SELECT GET_LOCK("MY_SUPER_LOCK_NAME", 15)', 'lock'],
    ['SELECT RELEASE_LOCK("MY_SUPER_LOCK_NAME")', 'lock'],
    ['SELECT IS_FREE_LOCK("MY_SUPER_LOCK_NAME")', 'lock'],
    ['SELECT IS_USED_LOCK("MY_SUPER_LOCK_NAME")', 'lock'],
    ['( SELECT 1 FROM DUAL ) UNION ( SELECT 2 FROM DUAL )', 'read'],
    ['( ( SELECT 1 FROM DUAL ) ) UNION ( SELECT 2 FROM DUAL )', 'read'],
);

for my $test (@tests) {
    my ($orig_sql, $expected_type) = @$test;
    for my $sql ($orig_sql, uc($orig_sql), lc($orig_sql)) {
        is(Yandex::DBTools::_get_statement_type($sql), $expected_type, "$sql is $expected_type query");
    }
}

done_testing;
