#!/usr/bin/perl -w

=pod

    $Id$

=cut

use strict;
use warnings;

use Test::Exception;
use Test::More;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

*pf = \&Yandex::DBTools::_parse_options_from_fieldname;

dies_ok { pf("cid__asdf"); } "unknown modifier";
dies_ok { pf("cid__like__not_like"); } "too many modifiers";
dies_ok { pf("cid__dont_quote__not_like__dont_quote"); } "too many dont_quote's";
dies_ok { pf("name__like__collate(") } "error in brackets";

my $f;

$f = pf("cid__dont_quote");
is($f->{dont_quote}, 1, '__dont_quote modifier');
ok(!exists$f->{op}, '__dont_quote modifier - 2');


$f = pf("cid__not_in");
ok(!$f->{dont_quote}, '__not_in modifier');
ok(exists$f->{op}, '__not_in modifier - 2');

$f = pf("cid__dont_quote__not_in");
is($f->{dont_quote}, 1, '__dont_quote + __not_in');
ok(exists$f->{op}, '__dont_quote + __not_in - 2');

$f = pf("_OR");
is($f->{field}, '_OR', '_OR');

$f = pf("name__like__collate(utf8_bin)");
is($f->{collate}, 'utf8_bin', 'collation');

done_testing();
