#!/usr/bin/perl -w

=pod

    $Id$

=cut

use strict;
use warnings;

use Test::More tests => 9;
use Test::Exception;

use Data::Dumper;
use Encode;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

create_table(UT, 'blobs' => 'id:pk', ':data blob');


my $bin_data1 =  join(Encode::encode_utf8(""), map {pack("C", $_)} 0..255);
my $bin_data2 =  join(Encode::encode_utf8(""), map {pack("C", $_)} 128..255);

do_insert_into_table(UNIT_TESTS, "blobs", {id => 1, data => $bin_data1});
is(get_one_field_sql(UNIT_TESTS, "select count(*) from blobs"), 1);
is(get_one_field_sql(UNIT_TESTS, "select data from blobs where id = 1"), $bin_data1);

do_replace_into_table(UNIT_TESTS, "blobs", {id => 2});
is(get_one_field_sql(UNIT_TESTS, "select count(*) from blobs"), 2);
is(get_one_field_sql(UNIT_TESTS, "select data from blobs where id = 2"), undef);

do_replace_into_table(UNIT_TESTS, "blobs", {id => 2, data => $bin_data1});
is(get_one_field_sql(UNIT_TESTS, "select count(*) from blobs"), 2);
is(get_one_field_sql(UNIT_TESTS, "select data from blobs where id = 2"), $bin_data1);

do_replace_into_table(UNIT_TESTS, "blobs", {id => 2, data => $bin_data2});
is(get_one_field_sql(UNIT_TESTS, "select count(*) from blobs"), 2);
is(get_one_field_sql(UNIT_TESTS, "select data from blobs where id = 2"), $bin_data2);

do_update_table(UNIT_TESTS, "blobs", {data => $bin_data1}, where => { id => 2 } );
is(get_one_field_sql(UNIT_TESTS, "select data from blobs where id = 2"), $bin_data1);
