#!/usr/bin/perl -w
use strict;
use warnings;

use Test::More tests => 6;
use Test::Exception;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;
use Data::Dumper;

my $LIMIT = 100;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

my($dbh, $sth, $table);

lives_ok
{
    my $data = [];
    my $str = "text " x 3210;
    for (my $i = 1; $i <= $LIMIT; $i++) {
        push(@$data, [$str]);
    }

    $table = create_table(UT, 'mytable' => qw/id:auto:pk mytext:text/);
#    do_mass_insert_sql(UT, "INSERT INTO $table (mytext) VALUES %s", (["text" x 3210]) x $LIMIT); # don't works
    do_mass_insert_sql(UT, "INSERT INTO $table (mytext) VALUES %s", $data);
} 'create table';

lives_ok
{
    $dbh = get_dbh(UT);
    $dbh->{mysql_use_result} = 1;
    $dbh->{PrintError} = 0;
} 'get database handler';
    
lives_ok
{
    $sth = $dbh->prepare("select * from $table as a join $table as b");
    $sth->execute();
} 'create statement handler and execute it';

lives_ok
{
    for (my $i = 1; $i <= int($LIMIT/3); $i++) {
    }
} 'fetch several rows';

lives_ok
{
    my $assassin = $dbh->clone();
    $assassin->do("kill ".$dbh->{mysql_thread_id});
} 'kill thread of dbh in the database';

dies_ok
{
    while($sth->fetchrow_arrayref) {
    }
} 'die while fetching with dead dbh';
connect_db(UT);
