#!/usr/bin/perl -w

=pod

    $Id$

=cut

use strict;
use warnings;

use Test::More tests => 9;
use Test::Exception;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

create_table(UT, 'test' => 'id:pk', 'cid:int', 'bid:int', 'name');

sub ins { do_insert_into_table(UT, @_); }
sub get { get_one_field_sql(UT, @_); }

is(get("select count(*) from test"), 0, 'empty table');

ins("test", {id => 0, cid => 1,  bid => 1, name => '111'});
ins("test", {id => 1, cid => 11, bid => 1, name => '222'});
ins("test", {id => 2, cid => 11, bid => 0, name => '123'});
ins("test", {id => 3, cid => 5,  bid => 0, name => 'yndx-3'});
ins("test", {id => 4, cid => 6,  bid => 8, name => '555-super'});

is(get("select count(*) from test"), 5, 'filled table');

my $f;

$f = get(["select count(*) from test", where => { id => 0 } ]);
is( $f, 1, 'simple hashref');

$f = get(["select count(*) from test", where => [ id__gt => 2 ] ]);
is( $f, 2, 'simple arrayref');

$f = get(["select count(*) from test", where => { _OR => [ name__like => '1%', name__like => '%3' ] } ]);
is( $f, 3, '_OR with same key');

$f = get(["select count(*) from test", where => { id__ne => 0, _TEXT => "bid > cid" } ]);
is( $f, 1, '_TEXT');


dies_ok { get(["select count(*) from test", where => { _or => { id__lt => 1, id__gt => 3 } } ]) }
    'die on lowercase _or';

dies_ok { get(["select count(*) from test", where => { __OR => { id__lt => 1, id__gt => 3 } } ]) }
    'die on __OR';

dies_ok { get(["select count(*) from test", where => { _OR => "id < 1 OR id > 3" } ]) }
    'die on non-ref _OR';



1;
