#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More;
use Test::Deep;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;


sub sel {
    return get_one_field_sql($_[0], "select connection_id()");
}

my $dbh = connect_db(UT);
ok(my $conid = sel(UT));
is(sel($dbh), $conid, "connection_id is the same for db and dbh");

disconnect_all();

is(scalar(keys %Yandex::DBTools::DBH_INFO), 0);

my $new_conid = sel(UT);
isnt($conid, $new_conid, "after disconnect_all connection_id changed");

done_testing();
