#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More;
use Test::Exception;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

my $thread_id = get_one_field_sql(UT, "SELECT connection_id()");
ok($thread_id > 0, "connected");

is($thread_id, get_one_field_sql(UT, "SELECT connection_id()"));

disconnect_db(UT);
isnt($thread_id, get_one_field_sql(UT, "SELECT connection_id()"));

done_testing();
