#!/usr/bin/perl -w

=pod

    $Id$

=cut

use strict;
use warnings;

use Test::More;
use Test::Exception;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use POSIX qw(:sys_wait_h);

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;
$Yandex::DBUnitTest::DEFAULT_ENGINE = 'InnoDB';


create_table(UT, 'names' => 'id:pk', 'name');
do_insert_into_table(UNIT_TESTS, "names", {id => 1, name => 'aa'});
ok(get_one_field_sql(UNIT_TESTS, "select count(*) from names") == 1, 'create');

do_in_transaction {
    do_insert_into_table(UNIT_TESTS, "names", {id => 2, name => 'bb'});
    do_insert_into_table(UNIT_TESTS, "names", {id => 3, name => 'cc'});
    do_insert_into_table(UNIT_TESTS, "names", {id => 4, name => 'dd'});
};
ok(get_one_field_sql(UNIT_TESTS, "select count(*) from names") == 4, 'commit');

dies_ok {
    do_in_transaction {
        do_delete_from_table(UNIT_TESTS, "names", where => { id__lt => 2 });
        die;
    };
} 'rollback dies';
is(get_one_field_sql(UNIT_TESTS, "select count(*) from names"), 4, 'rollback');

do_in_transaction {
    do_insert_into_table(UNIT_TESTS, "names", {id => 5, name => 'ee'});
    do_insert_into_table(UNIT_TESTS, "names", {id => 6, name => 'ff'});

    do_in_transaction { do_delete_from_table( UNIT_TESTS, "names", where => { id__lt => 2 } ) };
};
is(get_one_field_sql(UNIT_TESTS, "select count(*) from names"), 5, 'nested commit');

dies_ok {
    do_in_transaction {
        do_insert_into_table(UNIT_TESTS, "names", {id => 7, name => 'gg'});
        do_insert_into_table(UNIT_TESTS, "names", {id => 8, name => 'hh'});
        do_in_transaction {
            do_delete_from_table(UNIT_TESTS, "names", where => { id__lt => 3 });
            die;
        };
    };
} 'nested rollback dies';
is(get_one_field_sql(UNIT_TESTS, "select count(*) from names"), 5, 'nested rollback');

dies_ok {
    do_in_transaction {
        do_insert_into_table(UNIT_TESTS, "names", {id => 9, name => 'gg'});
        do_insert_into_table(UNIT_TESTS, "names", {id => 10, name => 'hh'});
        do_in_transaction { do_delete_from_table( UNIT_TESTS, "names", where => { id__lt => 3 } ) };
        die;
    };
} 'rollback with nested commit dies';
is(get_one_field_sql(UNIT_TESTS, "select count(*) from names"), 5, 'rollback with nested commit');

do_in_transaction {
    do_insert_into_table(UNIT_TESTS, "names", {id => 11, name => 'ii'});
    eval {
        do_in_transaction {
            do_insert_into_table(UNIT_TESTS, "names", {id => 13, name => 'kk'});
            do_insert_into_table(UNIT_TESTS, "names", {id => 14, name => 'll'});
            die;
        };
    };
    do_insert_into_table(UNIT_TESTS, "names", {id => 12, name => 'jj'});
};
is(get_one_field_sql(UNIT_TESTS, "select count(*) from names"), 7, 'commit with nested rollback');

sub _do_some_request {
    return get_one_field_sql(UNIT_TESTS, 'SELECT 1');
}

# открытые до начала транзакции соединения не должны ломаться внутри транзакции
_do_some_request();
lives_ok {
    do_in_transaction {
        my $child_pid = fork();
        if ($child_pid) {
            waitpid($child_pid, 0);
            ok(WIFEXITED($?) && WEXITSTATUS($?) == 0, 'child connection works after fork with alive connection');
            _do_some_request();
        } else {
            _do_some_request();
            exit 0;
        }
    };
} 'prior-fork connections must be usable after fork';

# не даём форкаться внутри транзакции
do_in_transaction {
    _do_some_request();
    my $child_pid = fork();
    if ($child_pid) {
        waitpid($child_pid, 0);
        # дитё должно умереть и не вернуть нулевого статуса
        ok(WIFEXITED($?) && WEXITSTATUS($?) != 0, 'child dies after fork inside active transaction');
    } else {
        # прячем сообщение о смерте, чтобы оно не попало в STDERR
        # без local'а, т.к. do_in_transaction тоже умрёт и его сообщение также хотим спрятать, а дело происходит в короткоживущем чайлде
        $SIG{__DIE__} = sub {die "\n"};
        # транзакцию начали в другом процессе, здесь должны сломаться
        _do_some_request();
        exit 0;
    }
};

done_testing;

#use YAML; print Dump get_all_sql(UNIT_TESTS, 'select * from names');

1;
