#!/usr/bin/perl -w

=pod

    $Id$

=cut

use strict;
use warnings;

use Test::More tests => 15;
use Test::Exception;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

create_table(UT, 'names' => 'id:pk', 'name');

ok(get_one_field_sql(UNIT_TESTS, "select count(*) from names") == 0);

do_insert_into_table(UNIT_TESTS, "names", {id => 1, name => 'qwerty'});
ok(get_one_field_sql(UNIT_TESTS, "select count(*) from names") == 1);

do_insert_into_table(UNIT_TESTS, "names", {id => 2, name => 'asdfg'});
ok(get_one_field_sql(UNIT_TESTS, "select count(*) from names") == 2);

eval {
    local get_dbh(UT)->{PrintError} = 0;
    do_insert_into_table(UNIT_TESTS, "names", {id => 2, name => 'asdfg'});
};
ok($@ =~ /Duplicate entry/, "Duplicate error exception");

do_insert_into_table(UNIT_TESTS, "names", {id => 2, name => 'asdfg'}, ignore => 1);
ok(get_one_field_sql(UNIT_TESTS, "select count(*) from names") == 2, "ignore duplicates");

dies_ok { local get_dbh(UT)->{PrintError} = 0; do_insert_into_table(UNIT_TESTS, "names", {id => 3, name__dont_quote => "value N 700"}); } "wrong unquoted value";

do_insert_into_table(UNIT_TESTS, "names", {id => 3, name__dont_quote => " 'value N 701' "});
ok(get_one_field_sql(UNIT_TESTS, "select count(*) from names") == 3, "dont_quote");

do_insert_into_table(UNIT_TESTS, "names", {id => 3, name__dont_quote => " 'value N 702' "}, on_duplicate_key_update => 1, key => [ 'id' ]);
ok(get_one_field_sql(UNIT_TESTS, "select count(*) from names") == 3, "dont_quote + on duplicate key update, count(*)");
ok(get_one_field_sql(UNIT_TESTS, "select name from names where id = 3") eq 'value N 702', "dont_quote + on duplicate key update, saved values");

do_insert_into_table(UNIT_TESTS, "names", {id => 4, name => 'value N 703'}, on_duplicate_key_update => 1, key => [ 'id' ]);

ok(do_insert_into_table(UNIT_TESTS, "names", {id => 3, name => 'value N 705'}, on_duplicate_key_update => 1, key => [ 'id' ]) == 3 , "on duplicate key update, return value");
ok(get_one_field_sql(UNIT_TESTS, "select name from names where id = 3") eq 'value N 705', "on duplicate key update, saved value");

create_table(UT, 'sets' => qw/id:pk:auto name/, ':pos int not null, unique key(pos)');
my $id1      = do_insert_into_table(UNIT_TESTS, "sets", {pos => 1, name => 'abc'}, on_duplicate_key_update => 1, key => 'id');
my $same_id1 = do_insert_into_table(UNIT_TESTS, "sets", {pos => 1, name => 'abc'}, on_duplicate_key_update => 1, key => 'id');
my $id2      = do_insert_into_table(UNIT_TESTS, "sets", {pos => 2, name => 'abc'}, on_duplicate_key_update => 1, key => 'id');
ok($id1 == $same_id1, 'On duplicate key update preserves PK value');
ok($id1 != $id2, 'on_duplicate_key_update was specified, but duplication did not happen, PK value was incremented');

my $id3  = do_insert_into_table(UNIT_TESTS, "sets", {pos => 3, name => 'abc'}, ignore => 1);
is($id3, 3, 'The third insert has id = 3');
my $ignored_id = do_insert_into_table(UNIT_TESTS, "sets", {pos => 3, name => 'abc'}, ignore => 1);
ok($id3 && !$ignored_id, 'Second insert ignore is really ignored');

1;
