#!/usr/bin/perl -w

=pod

    $Id$

=cut

use strict;
use warnings;

use Test::More tests => 10;
use Test::Deep;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

create_table(UT, 'table_orig' => 'id:pk', 'name');
create_table(UT, 'table_new' => 'id:pk', 'name');
do_mass_insert_sql(UT, "INSERT INTO table_orig (id, name) VALUES %s",
                   [[1,"name1"], [2,"name2"], [3,"name3"], [4,"name4"],]
    );


do_sql(UT, "DELETE FROM table_new");
is(4, do_insert_select_sql(UT, "INSERT INTO table_new (id, name) VALUES %s",
                     "SELECT id, name FROM table_orig",
    ));
cmp_bag(get_all_sql(UT, "SELECT id, name FROM table_orig"),
        get_all_sql(UT, "SELECT id, name FROM table_new"),
    );


do_sql(UT, "DELETE FROM table_new");
is(2, do_insert_select_sql(UT, "INSERT INTO table_new (id, name) VALUES %s",
                     "SELECT id, name FROM table_orig WHERE id < ?",
                     binds => [3],
    ));
cmp_bag(get_all_sql(UT, "SELECT id, name FROM table_orig where id < ?", 3),
        get_all_sql(UT, "SELECT id, name FROM table_new"),
    );


do_sql(UT, "DELETE FROM table_new");
is(2, do_insert_select_sql(UT, "INSERT INTO table_new (id, name) VALUES %s",
                     ["SELECT id, name FROM table_orig", WHERE => {id__lt => 3}]
    ));
cmp_bag(get_all_sql(UT, "SELECT id, name FROM table_orig where id < ?", 3),
        get_all_sql(UT, "SELECT id, name FROM table_new"),
    );


do_sql(UT, "DELETE FROM table_new");
is(1, do_insert_select_sql(UT, "INSERT INTO table_new (id, name) VALUES %s",
                     ["SELECT id, name FROM table_orig where id = ? and ", {id__lt => 3}],
                     binds => [1]
    ));
cmp_bag(get_all_sql(UT, "SELECT id, name FROM table_orig where id = ?", 1),
        get_all_sql(UT, "SELECT id, name FROM table_new"),
    );


do_sql(UT, "DELETE FROM table_new");
is(0, do_insert_select_sql(UT, "INSERT INTO table_new (id, name) VALUES %s",
                     "SELECT id, name FROM table_orig where id = 100"
    ));
cmp_bag([],
        get_all_sql(UT, "SELECT id, name FROM table_new"),
    );
