#!/usr/bin/perl -w

=pod

    $Id$

=cut

use strict;
use warnings;

use Test::More;
use Test::Exception;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

create_table(UT, 'names' => 'id:pk', 'name:mediumtext');
create_table(UT, 'blobs' => 'id:pk', 'name:mediumblob');

ok(get_one_field_sql(UNIT_TESTS, "select count(*) from names") == 0, 'create');

do_mass_insert_sql(UNIT_TESTS, "INSERT INTO names VALUES %s", [ [1, 'aa'], [2, 'bb'] ]);
ok(get_one_field_sql(UNIT_TESTS, "select count(*) from names") == 2, 'insert');

do_mass_insert_sql(UNIT_TESTS, "REPLACE INTO names VALUES %s", [ [1, 'cc'], [3, 'dd'] ]);
ok(get_one_field_sql(UNIT_TESTS, "select count(*) from names") == 3, 'replace');
ok(get_one_field_sql(UNIT_TESTS, "select name from names where id=1") eq 'cc', 'replace value');

do_mass_insert_sql(UNIT_TESTS, "INSERT INTO names VALUES %s", []);
ok(get_one_field_sql(UNIT_TESTS, "select count(*) from names") == 3, 'empty insert');

do_mass_insert_sql(UNIT_TESTS, "INSERT INTO names VALUES %s /* Я комментарий который выставляет utf8 флаг на этой строчке*/", 
                               [ [10, 'яндекс'], [20, 'bb'] ]);

ok(get_one_field_sql(UNIT_TESTS, "select count(*) from names where id = 10 and name = 'яндекс'") > 0, 'utf8 flag');

lives_ok {
    local get_dbh(UT)->{PrintError} = 0;
    do_mass_insert_sql(UNIT_TESTS, "INSERT INTO names (id, name) VALUES %s",
                       [[100, 'x']],
                       {sleep => 0, sleep_coef => 1}
        );
} "additional options";

dies_ok {
    local get_dbh(UT)->{PrintError} = 0;
    do_mass_insert_sql(UNIT_TESTS, "INSERT INTO names VALUES %s", { id => 4 });
} "wrong data";

dies_ok {
    local get_dbh(UT)->{PrintError} = 0;
    do_mass_insert_sql(UNIT_TESTS, "INSERT INTO names VALUES %s", [ { id => 4 } ]);
} "wrong data item";

dies_ok {
    local get_dbh(UT)->{PrintError} = 0;
    do_mass_insert_sql(UNIT_TESTS, "INSERT INTO names VALUES %s", [ [4] ]);
} "incomplete data item";


do_mass_insert_sql(UNIT_TESTS, "INSERT INTO blobs VALUES %s /* Я комментарий который выставляет utf8 флаг на этой строчке*/", 
                               [ [10, "\xDD"] ]);
is(get_one_field_sql(UNIT_TESTS, "select name from blobs where id = 10"), "\xDD", 'utf8 flag');


# много данных
do_mass_insert_sql(UNIT_TESTS, "INSERT INTO blobs (id, name) VALUES %s", 
                               [ map {[10+$_, $_ x 1e6]} (1..30) ]);
is(get_one_field_sql(UNIT_TESTS, "select count(*) from blobs"), 31, "many blobs");

$Yandex::DBTools::QUOTE_DB = undef;
lives_ok {do_mass_insert_sql(UT, "INSERT INTO blobs (id, name) VALUES %s", [[100, 'name']])} "do_mass_insert_sql works without global QUOTE_DB";

done_testing();

1;
