#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use Test::More;
use Test::Exception;

use Yandex::DBTools;
use Yandex::DBUnitTest;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;
#$Yandex::DBTools::QUERIES_LOG = 'dbtools_queries.log';

my %dataset = (
    names => {
        original_db => UT,
        create_string => ['id:pk', 'name', ':comment varchar(100) not null default "" ', 'sum:int', 'shows:int'],
        rows => [
            map {{id => $_, name => 'name_' . $_, comment => 'comment_' . $_, sum => 11*$_, shows => 0}} (1..10),
        ],
    },
    hashes => {
        original_db => UT,
        create_string => ['hash:varchar(10):pk', 'name'],
        rows => [
            map {{hash => $_, name => "hash_$_"}} ('a' .. 'c'),
        ],
    },
);
Yandex::DBUnitTest::init_test_dataset(\%dataset);

my $affected_rows_cnt = do_mass_update_sql(UT, 'names', id => {
    1 => {
        name => 'new_name_1',
        comment => 'new_comment_1',
        sum => 'id + 1000',
    },
    2 => {
        comment => 'new_comment_2',
    },
    3 => {
        name => 'new_name_3',
        comment => 'new_comment_3',
    },
    7 => {
        name => 'new_name_7',
        sum => 'id + 1000',
    },
    8 => {
        sum => 'id + 1000',
    },
}, where => {
    'sum__gt' => 15, # попадает всё кроме id=1
}, byfield_options => {
    name => { default => 'default_name' },
    shows => {default => 1},
    sum => { default__dont_quote => 'sum', dont_quote_value => 1 },
});

is($affected_rows_cnt, 4, 'affected rows count');

my %changed_dataset = %dataset;
$changed_dataset{names}->{rows} = [
    {
        'comment' => 'comment_1',
        'name' => 'name_1',
        'id' => '1',
        'sum' => '11',
        'shows' => '0',
    },
    {
        'comment' => 'new_comment_2',
        'name' => 'default_name',
        'id' => '2',
        'sum' => '22',
        'shows' => '1',
    },
    {
        'comment' => 'new_comment_3',
        'name' => 'new_name_3',
        'id' => '3',
        'sum' => '33',
        'shows' => '1',
    },
    {
        'comment' => 'comment_4',
        'name' => 'name_4',
        'id' => '4',
        'sum' => '44',
        'shows' => '0',
    },
    {
        'comment' => 'comment_5',
        'name' => 'name_5',
        'id' => '5',
        'sum' => '55',
        'shows' => '0',
    },
    {
        'comment' => 'comment_6',
        'name' => 'name_6',
        'id' => '6',
        'sum' => '66',
        'shows' => '0',
    },
    {
        'comment' => 'comment_7',
        'name' => 'new_name_7',
        'id' => '7',
        'sum' => '1007',
        'shows' => '1',
    },
    {
        'comment' => 'comment_8',
        'name' => 'default_name',
        'id' => '8',
        'sum' => '1008',
        'shows' => '1',
    },
    {
        'comment' => 'comment_9',
        'name' => 'name_9',
        'id' => '9',
        'sum' => '99',
        'shows' => '0',
    },
    {
        'comment' => 'comment_10',
        'name' => 'name_10',
        'id' => '10',
        'sum' => '110',
        'shows' => '0',
    },
];

Yandex::DBUnitTest::check_test_dataset(\%changed_dataset, 'changed data in table match expected');


$affected_rows_cnt = do_mass_update_sql(UT, 'hashes', hash => {
        a => { name => 'new a name' },
        c => { name => 'new c name' },
    });

is($affected_rows_cnt, 2, 'affected rows count with string id');

done_testing;
