#!/usr/bin/perl -w

=pod

    $Id$

=cut

use strict;
use warnings;

use Test::More tests => 13;
use Test::Exception;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

create_table(UT, 'names' => qw/id:pk name/);
 is(get_one_field_sql(UNIT_TESTS, "select count(*) from names"), 0);

 do_replace_into_table(UNIT_TESTS, "names", {id => 1, name => 'qwerty'});
 is(get_one_field_sql(UNIT_TESTS, "select count(*) from names"), 1);

 do_replace_into_table(UNIT_TESTS, "names", {id => 2, name => 'asdfg'});
 is(get_one_field_sql(UNIT_TESTS, "select count(*) from names"), 2);

 do_replace_into_table(UNIT_TESTS, "names", {id => 2, name => 'asdfg'});
 is(get_one_field_sql(UNIT_TESTS, "select count(*) from names"), 2);

 do_replace_into_table(UNIT_TESTS, "names", {id => 2, name => 'wrewrwer'});
 is(get_one_field_sql(UNIT_TESTS, "select count(*) from names"), 2, "replace, not add");
 is(get_one_field_sql(UNIT_TESTS, "select name from names where id=2"), 'wrewrwer');

 dies_ok { local get_dbh(UT)->{PrintError} = 0; do_replace_into_table(UNIT_TESTS, "names", {id => 3, name__dont_quote => "value N 700"}); } "wrong unquoted value";

 do_replace_into_table(UNIT_TESTS, "names", {id => 3, name__dont_quote => " 'value N 701' "});
 is(get_one_field_sql(UNIT_TESTS, "select count(*) from names"), 3, "dont_quote");

 # duplicate_key is not used in do_replace_into_table but if the flag and keys exists in parameters it shoul not break the function, duplicate_key just should be ignored.
 do_replace_into_table(UNIT_TESTS, "names", {id => 3, name => 'value N 703'}, on_duplicate_key_update => 1, key => [ 'id' ]);
 is(get_one_field_sql(UNIT_TESTS, "select count(*) from names"), 3, "on_duplicate_key_update doesn't break replace into table");
 is(get_one_field_sql(UNIT_TESTS, "select name from names where id = 3"), 'value N 703', "on duplicate key update, saved value");

 create_table(UT, 'sets' => qw/id:auto name :unique(name)/);
 my $id1 = do_replace_into_table(UNIT_TESTS, "sets", {name => 'abc'});
 is(get_one_field_sql(UNIT_TESTS, "select count(*) from sets where id=?", $id1), 1);

 my $id2 = do_replace_into_table(UNIT_TESTS, "sets", {name => 'abc'});
 is(get_one_field_sql(UNIT_TESTS, "select count(*) from sets where id=?", $id1), 0);
 isnt($id1, $id2, 'auto replace');
