#!/usr/bin/perl -w

=pod

    $Id$
    

=cut

use strict;
use warnings;

use Test::More;
use Test::Exception;

use Data::Dumper;
use Encode;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;
use constant PPC => 'ppc';

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;
#$Yandex::DBTools::QUERIES_LOG = 'dbtools_queries.log';

sub upd { do_update_table(UT, @_); }
sub ins { do_insert_into_table(UT, @_); }
sub get { get_one_field_sql(UT, @_); }
sub cnt { get_one_field_sql(UNIT_TESTS, "select count(*) from names"); }

# создаем таблицу, таблица пуста
create_table(UT, 'names' => 'id:pk', 'name', ':comment varchar(100) not null default "" ', 'sum:int');
# 
ok(cnt() == 0, "empty table");

# вносим в таблицу одну строку, она нормально вставляется
ins("names", {id => 1, name => 'qwerty'});
ok(cnt() == 1, "insert record");

# в текстовое NOT NULL поле заносим текст 'null' -- проходит нормально...
lives_ok {ins("names", {id => 2, name => 'asdf', comment => 'null' } );} "insert 'null' as text";
# ... а значение NULL -- не проходит
dies_ok {local get_dbh(UT)->{PrintError} = 0; ins("names", {id => 3, name => 'asdf', comment__dont_quote => 'null' } );} "insert NULL value into NOT NULL field";
# в таблице уже 2 строки
ok(cnt()==2, "rows count");

ins("names", {id => 0, name => 'zxcvb'});
ok(cnt()==3, "rows count");
# Сейчас в таблице 3 записи, с id 0,1,2

# пустые массивы в in, not_in
is(get(["select count(*) from names", where => { id => [] }]), 0, "in [] - 1");
is(get(["select count(*) from names", where => { id__in => [] }]), 0, "in [] - 2");
is(get(["select count(*) from names", where => { id__not_in => [] }]), 3, "not in []");


# в поле комментария копируем имя...
upd("names", {comment__dont_quote => 'name'}, where => { id__not_in => [0,2] } ); 
# ... и проверяем, что обновилась ровно одна строка
is(get("select count(*) from names where name = comment"), 1);
is(get(["select count(*) from names", where => { name__dont_quote => 'comment' } ]), 1);
is(get(["select count(*) from names", where => { name => 'comment' } ]), 0);

# недопустимое сочетание модификаторов для обновляемых полей
dies_ok {upd("names", {comment__dont_quote__not_in => 'name'}, where => { id => [0,2] } );} "incorrect modifiers in SET statement";
# недопустимое сочетание модификаторов в условии для обновления
dies_ok {upd("names", {comment => 'name'}, where => { id__not_in__ge => [0,2] } );} "incorrect modifiers in WHERE statement";

# between
ins("names", {id => 101, name => 'qwerty-101'});
ins("names", {id => 102, name => 'qwerty-102'});
ins("names", {id => 103, name => 'qwerty-103'});
ins("names", {id => 104, name => 'qwerty-104'});
ins("names", {id => 105, name => 'qwerty-105'});
is(get(["select count(*) from names", where => { id__between => [100, 103] }]), 3, "between-1");
is(get(["select count(*) from names", where => { id__between => [105, 102] }]), 0, "between-2");
dies_ok { get(["select count(*) from names", where => { id__between => 105 }]) } "wrong between-1"; 
dies_ok { get(["select count(*) from names", where => { id__between => [105] }]) } "wrong between-2"; 
dies_ok { get(["select count(*) from names", where => { id__between => [105, 103, 108] }]) } "wrong between-3"; 


# is
is(get(["select count(*) from names", where => {id__is => 101}]), 1, "is - 1");
is(get(["select count(*) from names", where => {id__is => undef}]), 0, "is - 2");
dies_ok {get(["select count(*) from names", where => {id__is => [101,102]}])}  "is - scalar required";

# test utf8 data
upd("names", {comment => "Привет, мир!"}, where => { id => 102 } ); 
is(get(["select comment from names", where => {id => 102}]), "Привет, мир!");

upd("names n1 join names n2 using (id)", {'n2.comment' => "Прощай, мир!"}, where => { 'n1.id' => 102 } ); 
is(get(["select comment from names", where => {id => 102}]), "Прощай, мир!", 'update joined tables');

done_testing;
