#!/usr/bin/perl -w

=pod

    $Id$

=cut

use strict;
use warnings;

use Test::More;
use Test::Exception;
use Test::Deep;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

######################
# tests for sharded db

do_sql(SHUT(shard => 'all'), "CREATE TABLE st (i int)");
is(get_one_field_sql(SHUT_1, "SELECT count(*) FROM st"), 0, "check all tables empty");
is(get_one_field_sql(SHUT_2, "SELECT count(*) FROM st"), 0);
do_insert_into_table(SHUT_1, "st", {i=>1});
is(get_one_field_sql(SHUT_1, "SELECT count(*) FROM st"), 1, "check one table empty");
is(get_one_field_sql(SHUT_2, "SELECT count(*) FROM st"), 0);
do_insert_into_table(SHUT_2, "st", {i=>2});
do_insert_into_table(SHUT_2, "st", {i=>3});
is(get_one_field_sql(SHUT_1, "SELECT count(*) FROM st"), 1, "check all tables not empty");
is(get_one_field_sql(SHUT_2, "SELECT count(*) FROM st"), 2);
cmp_deeply(get_one_column_sql(SHUT(shard => 'all'), "SELECT * FROM st"), bag(1,2,3));

done_testing();

1;
