#!/usr/bin/perl -w

use strict;
use warnings;

use List::Util qw/sum/;
use JSON;

use Test::Exception;
use Test::Deep;
use Test::More;

use Yandex::DBTools;
use Yandex::DBUnitTest;

use utf8;

%Yandex::DBTools::DB_CONFIG = (
    utf8 => 1,
    port => 3306,
    user => 'root',
    connect_timeout => 4,
    CHILDS => {
        ppc => {
            host => 'ppcdata1.yandex.ru',
            CHILDS => {
                _ => {},
                slave => {
                    utf8 => 0,
                    ReadOnly => 1,
                }
            }
        },
        ppcstat => {
            CHILDS => {
                1 => {},
                2 => {}
            }
        },
        pass1 => {
            pass => 'asfd',
        },
        rec => {
            CHILDS => {
                rec2 => {
                    CHILDS => {
                        rec21 => {},
                        rec22 => {},
                    },
                },
            },
        },
    }
    );

my @all = ('ppc', 'ppc:slave', 'ppcstat:1', 'ppcstat:2', 'pass1', 'rec:rec2:rec21', 'rec:rec2:rec22');

# тесты сгруппированны по префиксу
# если результат undef - значит должен выбраываться эксепшн
# регексп определяет фильтр для @all
my @tests = (
    {
        prefix => 'test',
        cases => [
            [] => undef,
            [recursive => 1] => undef,
            ],
    },
    {
        prefix => 'ppc',
        cases => [
            [] => ['ppc:slave'],
            [recursive => 1] => ['ppc:slave'],
            ],
    },
    {
        prefix => 'ppcstat',
        cases => [
            [] => qr/^ppcstat:/,
            [recursive => 1] => qr/^ppcstat:/,
            ],
    },
    {
        prefix => 'pass1',
        cases => [
            [] => [],
            [recursive => 1] => [],
            ],
    },
    {
        prefix => 'ppcstat:1',
        cases => [
            [] => [],
            [recursive => 1] => [],
            ],
    },
    {
        prefix => undef,
        cases => [
            [] => ['ppc', 'pass1'],
            [recursive => 1] => \@all,
            ],
    },
    {
        prefix => '',
        cases => [
            [] => ['ppc', 'pass1'],
            [recursive => 1] => \@all,
            ],
    },
    {
        prefix => 'rec',
        cases => [
            [] => [],
            [recursive => 1] => qr/^rec:/,
            ],
    },
    );

plan tests => sum map {scalar(@{$_->{cases}})/2} @tests;

for my $test (@tests) {
    my @cases = @{$test->{cases}};
    while(my ($options, $result) = splice(@cases, 0, 2)) {
        my $text = "get_db_childs ".to_json([$test->{prefix}, @$options]);
        if (!defined $result) {
            dies_ok {get_db_childs($test->{prefix}, @$options)} $text;
        } else {
            my @test_res = 
                ref $result eq 'ARRAY' ? @$result
                : ref $result eq 'Regexp' ? grep {/$result/} @all
                : die "Unsupported result type: ".ref($result);
            cmp_deeply(get_db_childs($test->{prefix}, @$options), bag(@test_res), $text);
        }
    }
}

