#!/usr/bin/perl -w

use strict;
use warnings;

use File::Slurp;
use File::Temp qw/tempfile/;

use Test::Exception;
use Test::Deep;
use Test::More;

use Yandex::DBTools;
use Yandex::DBUnitTest;

use utf8;

dies_ok {get_db_config('test')} 'No config';

my $pass = "super-mega-passwd!@#$%";
my (undef, $tmpfile1) = tempfile(UNLINK => 1);
write_file($tmpfile1, $pass);
my (undef, $tmpfile2) = tempfile(UNLINK => 1);
write_file($tmpfile2, "
# comment1
 $pass 
# comment2
");
my (undef, $tmpfile3) = tempfile(UNLINK => 1);
write_file($tmpfile3, "some-other-pass");

%Yandex::DBTools::DB_CONFIG = (
    utf8 => 1,
    port => 3306,
    user => 'root',
    connect_timeout => 4,
    CHILDS => {
        ppc => {
            host => 'ppcdata1.yandex.ru',
            instance => 'ppcdata1',
            CHILDS => {
                _ => {},
                slave => {
                    utf8 => 0,
                    ReadOnly => 1,
                    extra_users => {
                        extra_user_0 => {
                            pass => 'extra_pass_0'
                        },
                    },
                }
            }
        },
        ppcstat => {
            CHILDS => {
                1 => {},
                2 => {}
            }
        },
        ppcdict => {
            CHILDS => {
                '_' => {},
                'adi' => {db => 'adi'},
            }
        },
        pass1 => {
            pass => {file => $tmpfile1},
        },
        pass2 => {
            pass => {file => $tmpfile2},
        },
        eu => {
            CHILDS => {
                _ => {},
                slave => {
                    utf8 => 0,
                    ReadOnly => 1,
                    extra_users => {
                        extra_user_2 => {
                            pass => 'extra_pass_22'
                        },
                    },
                },
            },
            extra_users => {
                extra_user_1 => {
                },
                extra_user_2 => {
                    pass => 'extra_pass_2'
                },
                extra_user_3 => {
                    pass => { file => $tmpfile3 },
                },
            },
        },
    }
    );


dies_ok {get_db_config('test')} 'No such config';

is_deeply(get_db_config('ppc'), {dbname => 'ppc', db => 'ppc', utf8 => 1, port => 3306, user => 'root',
                                 connect_timeout => 4, host => 'ppcdata1.yandex.ru',
                                 instance => 'ppcdata1'});
is_deeply(get_db_config('ppc'), get_db_config('ppc:_'));

is_deeply(get_db_config('ppc:slave'), {dbname => 'ppc:slave', db => 'ppc', utf8 => 0, port => 3306, user => 'root',
                                       connect_timeout => 4, host => 'ppcdata1.yandex.ru', ReadOnly => 1,
                                       instance => 'ppcdata1'});

dies_ok {get_db_config('ppcstat')} 'No such config';
is_deeply(get_db_config('ppcstat:1'), {dbname => 'ppcstat:1', db => 'ppcstat', utf8 => 1, port => 3306, user => 'root',
                                       connect_timeout => 4, instance => 'ppcstat'});

is_deeply(get_db_config('ppcdict'), {dbname => 'ppcdict', db => 'ppcdict', utf8 => 1, port => 3306, user => 'root',
                                       connect_timeout => 4, instance => 'ppcdict'});
is_deeply(get_db_config('ppcdict:adi'), {dbname => 'ppcdict:adi', db => 'adi', utf8 => 1, port => 3306, user => 'root',
                                       connect_timeout => 4, instance => 'ppcdict'});


is_deeply(get_db_config('pass1'), {dbname => 'pass1', db => 'pass1', utf8 => 1, port => 3306, user => 'root',
                                       connect_timeout => 4, pass => $pass, instance => 'pass1'});
is_deeply(get_db_config('pass2'), {dbname => 'pass2', db => 'pass2', utf8 => 1, port => 3306, user => 'root',
                                       connect_timeout => 4, pass => $pass, instance => 'pass2'});

is_deeply(get_db_config('eu', db_user => 'extra_user_1'), { dbname => 'eu', db => 'eu', utf8 => 1, port => 3306, user => 'extra_user_1',
                                 connect_timeout => 4, 
                                 pass => '', instance => 'eu'});
is_deeply(get_db_config('eu', db_user => 'extra_user_2'), {dbname => 'eu', db => 'eu', utf8 => 1, port => 3306, user => 'extra_user_2',
                                 connect_timeout => 4, 
                                 pass => 'extra_pass_2', instance => 'eu'});
is_deeply(get_db_config('eu:slave', db_user => 'extra_user_2'), {dbname => 'eu:slave', db => 'eu', utf8 => 0, port => 3306, user => 'extra_user_2',
                                       connect_timeout => 4, ReadOnly => 1,
                                       pass => 'extra_pass_22', instance => 'eu'});
is_deeply(get_db_config('eu', db_user => 'extra_user_3'), {dbname => 'eu', db => 'eu', utf8 => 1, port => 3306, user => 'extra_user_3',
                                 connect_timeout => 4, 
                                 pass => 'some-other-pass', instance => 'eu'});

is_deeply(get_db_config('ppc:slave', db_user => 'extra_user_0'), {dbname => 'ppc:slave', db => 'ppc', utf8 => 0, port => 3306, user => 'extra_user_0',
                                       connect_timeout => 4, host => 'ppcdata1.yandex.ru', ReadOnly => 1,
                                       pass => 'extra_pass_0', instance => 'ppcdata1'});
# неоднозначный момент: соглашаться принимать любой db_user, или только из входящих в extra_users?
# подменить user и pass в готовом хеше ничего не мешает, так что вроде бы лучше проверять и не позволять несуществующих
dies_ok { get_db_config('ppc', db_user => 'extra_user_wrong'), } 'nonexistent extra_user';
dies_ok { get_db_config('ppc:slave', db_user => 'extra_user_wrong'), } 'nonexistent extra_user';
dies_ok { get_db_config('eu', db_user => 'extra_user_wrong'), } 'nonexistent extra_user';

done_testing();
