#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More tests => 24;
use Test::Exception;

use Data::Dumper;
use DBD::Mock;

use Yandex::DBTools;

use constant PPC => 'ppc';
use constant PPC_SLAVE => 'ppc:slave';
use constant PPC_HEAVY => 'ppc:heavy';

use utf8;

%Yandex::DBTools::DB_CONFIG = (
    driver => 'Mock(PrintWarn=>0,PrintError=>0)',
    port => 3306,
#    utf8 => 1,
    user => '', pass => '',
    CHILDS => {
        'ppc' => {
            host => 'ppcdata1.yandex.ru',
            ping_timeout => 0, 
            CHILDS => {
                _ => {},
                slave => {host => 'ppcdata1-slave.yandex.ru'},
                heavy => {host => 'ppcheavy.yandex.ru'},
            }
        },
        'ppcdict' => {
            host => 'ppcmaster.yandex.ru',
            port => 3311,
            pass => 'utro',
        },
        'ppclog' => {
            host => ['bad.yandex.ru', 'good.yandex.ru', 'good2.yandex.ru'],
            port => 3311,
            pass => 'utro',
        },
    }
    );
# "ручка" для управления 
my $drh = DBI->install_driver('Mock');

# проверяем, что get_dbh коннектится
my $dbh_ppc;
ok(eval {$dbh_ppc = get_dbh(PPC);}, "get_dbh by name");
ok($dbh_ppc->isa('DBI::db'), "right type");

# проверяем, что get_dbh возвращает тот же хэндл по имени и по dbh

# ограничиваем возможность законнектиться
$drh->{mock_connect_fail} = 1;
my $dbh_ppc_new;
ok(eval {$dbh_ppc_new = get_dbh(PPC);}, "second get_dbh by name");
ok($dbh_ppc eq $dbh_ppc_new, "same dbh");

ok(eval {$dbh_ppc_new = get_dbh($dbh_ppc);}, "get_dbh by dbh");
ok($dbh_ppc eq $dbh_ppc_new, "same dbh");

# connect_db по-любому пытается переконнектиться. возможно это поведение стоит изменить
ok(!eval {$dbh_ppc_new = connect_db(PPC);}, "connect by name when network down");
$drh->{mock_connect_fail} = 0;
ok(eval {$dbh_ppc_new = connect_db(PPC);}, "connect by name when network on");
ok($dbh_ppc eq $dbh_ppc_new, "same dbh");

# при потере коннекта - создаём новый
ok($dbh_ppc->ping(), "ping");
$dbh_ppc->{mock_can_connect} = 0;
ok(!$dbh_ppc->ping(), "ping failed");
ok(eval {$dbh_ppc_new = get_dbh(PPC);}, "get_dbh by name");
ok($dbh_ppc_new eq $dbh_ppc, "same dbh");
ok($dbh_ppc->ping(), "ping");

# проверяем работу со слейвом
set_slave_db(PPC, PPC_SLAVE);
ok(get_dbh(PPC) eq get_dbh(PPC), "Slave not connected");

ok(get_dbh(PPC) ne get_dbh(PPC_SLAVE), "Connect to slave");
ok(get_dbh(PPC) eq get_dbh(PPC), "Slave wo sql");

is(get_dbh(PPC, "SELECT * FROM qqq"), get_dbh(PPC_SLAVE), "Slave w select");
ok(get_dbh(PPC, "SELECT /* sendmaster */ * FROM qqq") eq get_dbh(PPC), "Slave w sendppc");
ok(get_dbh(PPC, "UPDATE qqq") eq get_dbh(PPC), "Slave w update");

Yandex::DBTools::save_dbh2(connect_db(PPC_HEAVY));
is(get_dbh(PPC, "SELECT * FROM qqq"), get_dbh(PPC_HEAVY), "Slave w select");

{
    # проверяем, что если указано несколько хостов и к первому не удалось законнектиться - коннектимся ко второму
    no strict 'refs';
    no warnings;
    local $drh->{mock_connect_fail} = 1;
    my $orig_get_db_dsn = *{"Yandex::DBTools::get_db_dsn"}{CODE};
    my $connect_tries = 0;
    local *{"Yandex::DBTools::get_db_dsn"} = sub {
        # к bad.yandex.ru законнектиться нельзя, к остальным можно
        $drh->{mock_connect_fail} = $_[1] =~ /^bad/;
        $connect_tries++;
        return $orig_get_db_dsn->(@_);
    };
    my $ppclog_dbh;
    lives_ok {$ppclog_dbh = get_dbh('ppclog')} 'get_dbh ppclog alive';
    is $connect_tries, 2, 'two connect attempts';
    like $ppclog_dbh->{Name} || '', qr/hostname=good.yandex.ru/, "get_dbh ppclog connected to good.yandex.ru";
}

