#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More;
use Test::Deep;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

create_table(UT, 'test' => 'num:int', 'name');

do_mass_insert_sql(UT, 'INSERT INTO test VALUES %s', [
                       [undef, undef],
                       [1, 'k1'],
                       [1, 'k1'],
                       [2, 'k2']
                   ]);

sub gh {
    return get_hash_sql(UT, @_);
}

cmp_deeply(gh("select num, name from test"),
           {
               '' => undef,
               '1' => 'k1',
               '2' => 'k2'
           }
    );
cmp_deeply(gh("select name, num from test"),
           {
               '' => undef,
               'k1' => 1,
               'k2' => 2
           }
    );
cmp_deeply(get_hash_sql(SHUT(shard => []), "select num, name from test"),
           {
           }
    );

done_testing;
