#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More;
use Test::Deep;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

create_table(UT, 'test' => 'num:int', 'name');

do_mass_insert_sql(UT, 'INSERT INTO test VALUES %s', [
                       [undef, undef],
                       [1, 'k1'],
                       [1, 'k1'],
                       [2, 'k2'],
                   ]);

sub ghh {
    return get_hashes_hash_sql(UT, @_);
}

cmp_deeply(ghh("select num, name from test"),
           {
               '' => {num => undef, name => undef},
               '1' => {num => 1, name => 'k1'},
               '2' => {num => 2, name => 'k2'},
           }
    );
cmp_deeply(ghh("select name, num from test"),
           {
               '' => {num => undef, name => undef},
               'k1' => {num => 1, name => 'k1'},
               'k2' => {num => 2, name => 'k2'},
           }
    );
cmp_deeply(get_hashes_hash_sql(SHUT(shard => []), "select name, num from test"),
           {
           }
    );

done_testing;
