#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More;
use Test::Deep;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

create_table(UT, 'test' => 'num:int', 'name');

do_mass_insert_sql(UT, 'INSERT INTO test VALUES %s', [
                       [undef, undef],
                       [1, 'k1'],
                       [1, 'k1'],
                       [2, 'k2']
                   ]);

sub t {
    return get_one_column_sql(UT, @_);
}

cmp_deeply(t("select num from test"),
           bag(undef, 1, 1, 2)
    );

cmp_deeply(t("select num, name from test"),
           bag(undef, 1, 1, 2)
    );

cmp_deeply(t("select num from test where 0"),
           []
    );

cmp_deeply(t("select num from test where name like '%2'"),
           [2]
    );

done_testing;
