#!/usr/bin/perl -w

=pod

    $Id$

=cut

use strict;
use warnings;
use utf8;
use Test::More 'tests' => 14;
use Test::Exception;
use Test::Deep;
use Yandex::DBTools qw//;
use Yandex::DBUnitTest qw/:all/;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

sub get_statement_type;

my $sql_statement =<< 'SQL';

    -- my comment 1 \-\- test
    /* my
       comment2
    */

    /* my comment 2 2 */

    # my comment 3

    SELECT 1 FROM DUAL
        -- my comment 3
        /* my
           comment4
        */

        # my comment 6
SQL
                                                            
is( get_statement_type( $sql_statement ), 'read', 'Statement type "read": SELECT.' );

$sql_statement =<< 'SQL';
    -- my comment 1
    SET @t=NOW();
SQL

is( get_statement_type( $sql_statement ), 'read', 'Statement type "read": SET.' );

$sql_statement =<< 'SQL';
    -- my comment 1
    SELECT GET_LOCK('lock1',10)
SQL

is( get_statement_type( $sql_statement ), 'lock', 'Statement type "lock": SELECT GET_LOCK(..).' );

$sql_statement =<< 'SQL';
    -- my comment 1
    SELECT RELEASE_LOCK('lock1')
SQL

is( get_statement_type( $sql_statement ), 'lock', 'Statement type "lock": SELECT RELEASE_LOCK(..).' );

$sql_statement =<< 'SQL';
    -- my comment 1
    SELECT IS_FREE_LOCK('lock1')
SQL

is( get_statement_type( $sql_statement ), 'lock', 'Statement type "lock": SELECT IS_FREE_LOCK(..).' );

$sql_statement =<< 'SQL';
    -- my comment 1
    SELECT IS_USED_LOCK('lock1')
SQL

is( get_statement_type( $sql_statement ), 'lock', 'Statement type "lock": SELECT IS_USED_LOCK(..).' );

$sql_statement =<< 'SQL';
    -- my comment 1
    LOCK TABLES test1
SQL

is( get_statement_type( $sql_statement ), 'unknown', 'Statement type "unknown": LOCK.' );

$sql_statement =<< 'SQL';
    -- my comment 1
    UPDATE TABLE table1 SET field1='value1' WHERE key1='key_value'
SQL

is( get_statement_type( $sql_statement ), 'write', 'Statement type "write": UPDATE.' );

$sql_statement =<< 'SQL';
    -- my comment 1
    INSERT INTO table1 (f1,f2) VALUES(1,2),(3,4);
SQL

is( get_statement_type( $sql_statement ), 'write', 'Statement type "write": INSERT.' );

$sql_statement =<< 'SQL';
    -- my comment 1
    REPLACE INTO table1 (f1,f2) VALUES(1,2),(3,4);
SQL

is( get_statement_type( $sql_statement ), 'write', 'Statement type "write": REPLACE.' );

$sql_statement =<< 'SQL';
    -- my comment 1
    DELETE FROM table1 WHERE key='value';
SQL

is( get_statement_type( $sql_statement ), 'write', 'Statement type "write": DELETE.' );

$sql_statement =<< 'SQL';
    -- my comment 1
    CREATE TEMPORARY TABLE `table1` (
       `id` int(11) NOT NULL DEFAULT '0',
       `name` varchar(32) DEFAULT NULL,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8
SQL

is( get_statement_type( $sql_statement ), 'write', 'Statement type "write": CREATE.' );

$sql_statement =<< 'SQL';
    -- my comment 1
    DROP TABLE `table1`
SQL

is( get_statement_type( $sql_statement ), 'write', 'Statement type "write": DROP.' );

$sql_statement =<< 'SQL';
    -- my comment 1
    (
     ( SELECT 1 FROM DUAL ) )
     UNION
     ( SELECT 2 FROM DUAL )
SQL

is( get_statement_type( $sql_statement ), 'read', 'Statement type "read": (SELECT.' );


done_testing();

sub get_statement_type {
    return Yandex::DBTools::_get_statement_type( @_ );
}

1;
__END__
