#!/usr/bin/perl -w

=pod

    Проверяем, что InactiveDestroy нам не нужен

=cut

use strict;
use warnings;

use Test::More tests => 7;
use Test::Exception;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

my $thread_id = get_one_field_sql(UT, "SELECT connection_id()");
ok($thread_id > 0, "connected");

# проверяем, что происходит, если чайлд использует коннект 
my $pid = fork();
if (!defined $pid) {
    die "Fork failed: $!";
} elsif (!$pid) {
    # child
    if ($thread_id != get_one_field_sql(UT, "SELECT connection_id()")) {
        # в форкнутом процессе мы автоматически переконнектились
        exit 0;
    } else {
        die "the same thread_id!";
    }
} else {
    # parent
    if (waitpid($pid, 0) < 0 || $?) {
        die "child process terminated abnormally: $!";
    } else {
        pass("child process reconnected");
    }
}

# в основном процессе остался изначальный коннект
is($thread_id, get_one_field_sql(UT, "SELECT connection_id()"), "parent process have old connect");

ok((grep {$_->{Id} == $thread_id} @{get_all_sql(UT, "SHOW PROCESSLIST")}), "old connect exists 1");

# проверяем, что происходит, если чайлд не использует коннект 
my $pid2 = fork();
if (!defined $pid2) {
    die "Can't fork: $!";
} elsif (!$pid2) {
    exit 0;
}
ok((grep {$_->{Id} == $thread_id} @{get_all_sql(UT, "SHOW PROCESSLIST")}), "old connect exists 2");

connect_db(UT);
isnt($thread_id, get_one_field_sql(UT, "SELECT connection_id()"), "new connect from connect_db");
ok((not grep {$_->{Id} == $thread_id} @{get_all_sql(UT, "SHOW PROCESSLIST")}), "old connect destroyed");

1;
