#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More;
use Log::Any::Test;
use Log::Any qw/$log/;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;


create_table(UT, 'tmp' => ':id tinyint(1)', ':st SET("st", "st1", "st2") not null');

my $category = $Yandex::DBTools::LOG_WARNINGS_CATEGORY;

do_insert_into_table(UT, "tmp", {id => 1, st => "st"});
$log->category_does_not_contain_ok($category, qr/./, 'no warnings after correct insert');

do_insert_into_table(UT, "tmp", {id => 2, st => "xxx"});
$log->category_contains_ok($category, qr/Warning 1265/, 'truncated set');
$log->clear;

local $Yandex::DBTools::LOG_WARNINGS_COUNT = 5;
do_insert_into_table(UT, "tmp", {id => 222, st => "zzz"});
$log->category_contains_ok($category, qr/Warning 1264/, 'two warnings: first');
$log->category_contains_ok($category, qr/Warning 1265/, 'two warnings: second');
$log->clear;

local $Yandex::DBTools::LOG_WARNINGS_COUNT = 1;
do_insert_into_table(UT, "tmp", {id => 222, st => "zzz"});
$log->category_contains_ok($category, qr/more skipped/, 'limited: first with extra message');
$log->category_does_not_contain_ok($category, qr/./, 'limited: second skipped');
$log->clear;

done_testing;

