#!/usr/bin/perl -w

=head1

    Парсинг data_source формата DBI

=cut

use strict;
use warnings;

use Test::More tests => 3;
use Test::Deep;

use Yandex::DBTools;

sub pds {
    Yandex::DBTools::parse_data_source(@_);
}

cmp_deeply(
    pds('DBI:mysql:ppcdict:ppcmaster01b.yandex.ru:3311;mysql_enable_utf8=1;mysql_connect_timeout=60'),
    {db => 'ppcdict', host => 'ppcmaster01b.yandex.ru', port => 3311},
    'host:port',
    );
cmp_deeply(
    pds('dbi:mysql:ppclog;hostname=test-mysql.yandex.ru;port=3309;mysql_enable_utf8=1'),
    {db => 'ppclog', host => 'test-mysql.yandex.ru', port => 3309},
    'port as param',
    );
cmp_deeply(
    pds('dbi:mysql:ppc;mysql_socket=/var/run/mysqld.ppc/mysqld.sock;mysql_enable_utf8=1'),
    {db => 'ppc', mysql_socket => '/var/run/mysqld.ppc/mysqld.sock'},
    'socket',
    );


