#!/usr/bin/perl -w

=pod

    $Id$

=cut

use strict;
use warnings;

use Test::More;
use Test::Exception;

use Data::Dumper;

use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;

use utf8;

$Yandex::DBTools::DONT_SEND_LETTERS = 1;

create_table(UT, 'table01' => qw/id:pk name/);

ok(get_one_field_sql(UNIT_TESTS, "select count(*) from table01") == 0);

lives_ok { (do_insert_into_table(UNIT_TESTS, "table01", {id => 1, name => 'qwerty'})) } "insert in rw dbh";

get_dbh(UNIT_TESTS)->{ReadOnly} = 1;

dies_ok { (do_insert_into_table(UNIT_TESTS, "table01", {id => 2, name => 'qwerty'})) } "insert in ro dbh";

lives_ok { do_insert_into_table(UNIT_TESTS, "table01", {id => 2, name => 'qwerty'}, no_readonly => 1) } "insert in rw dbh";

lives_ok { do_sql(UNIT_TESTS, "update /* no_readonly */ table01 set name = 'new' where id = 1") } "insert in rw dbh";

dies_ok { do_sql(UNIT_TESTS, "drop table table01") } "drop in ro dbh";

lives_ok { get_one_field_sql(UNIT_TESTS, "select count(*) from table01") } "select from ro dbh";
lives_ok { get_one_field_sql(UNIT_TESTS, "explain select count(*) from table01") } "explain select from ro dbh";
lives_ok { get_one_field_sql(UNIT_TESTS, "desc table01") } "desc from ro dbh";

get_dbh(UNIT_TESTS)->{ReadOnly} = 0;

done_testing;
